/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.command.UngroupByColumnIndexCommand;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.MenuItemProviders;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GroupByHeaderMenuConfiguration
extends AbstractUiBindingConfiguration {
    private final NatTable natTable;
    private final GroupByHeaderLayer groupByHeaderLayer;

    public GroupByHeaderMenuConfiguration(NatTable natTable, GroupByHeaderLayer groupByHeaderLayer) {
        this.natTable = natTable;
        this.groupByHeaderLayer = groupByHeaderLayer;
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, "GROUP_BY_REGION", 3){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                if (super.matches(natTable, event, regionLabels)) {
                    int groupByColumnIndex = GroupByHeaderMenuConfiguration.this.groupByHeaderLayer.getGroupByColumnIndexAtXY(event.x, event.y);
                    return groupByColumnIndex >= 0;
                }
                return false;
            }
        }, (IMouseAction)new PopupMenuAction(new PopupMenuBuilder(this.natTable).withMenuItemProvider(new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText("Ungroup By");
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        NatEventData natEventData = MenuItemProviders.getNatEventData((SelectionEvent)event);
                        int columnPosition = natEventData.getColumnPosition();
                        int rowPosition = natEventData.getRowPosition();
                        MouseEvent originalEvent = natEventData.getOriginalEvent();
                        ILayerCell cell = natTable.getCellByPosition(columnPosition, rowPosition);
                        Rectangle bounds = cell.getBounds();
                        int groupByColumnIndex = GroupByHeaderMenuConfiguration.this.groupByHeaderLayer.getGroupByColumnIndexAtXY(originalEvent.x - bounds.x, originalEvent.y - bounds.y);
                        natTable.doCommand((ILayerCommand)new UngroupByColumnIndexCommand(groupByColumnIndex));
                    }
                });
            }
        }).build()));
    }
}

