/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class ScrollBarHandlerTemplate
implements Listener {
    public static final int DEFAULT_OFFSET = 1;
    protected final ViewportLayer viewportLayer;
    protected final IUniqueIndexLayer scrollableLayer;
    protected final ScrollBar scrollBar;
    private boolean dragging = false;

    public ScrollBarHandlerTemplate(ViewportLayer viewportLayer, ScrollBar scrollBar) {
        this.viewportLayer = viewportLayer;
        this.scrollableLayer = viewportLayer.getScrollableLayer();
        this.scrollBar = scrollBar;
        this.scrollBar.addListener(13, (Listener)this);
    }

    public void dispose() {
        if (this.scrollBar != null && !this.scrollBar.isDisposed()) {
            this.scrollBar.removeListener(13, (Listener)this);
        }
    }

    public void handleEvent(Event event) {
        boolean handle = true;
        if (!this.dragging) {
            handle = ActiveCellEditor.commit();
        }
        this.dragging = event.detail == 1;
        if (handle) {
            ScrollBar scrollBar = (ScrollBar)event.widget;
            int position = this.getPositionByPixel(this.getViewportPixelOffset() + scrollBar.getSelection());
            this.setViewportOrigin(position);
        } else {
            this.adjustScrollBar();
        }
    }

    void adjustScrollBar() {
        if (this.scrollBar.isDisposed()) {
            return;
        }
        int scrollablePosition = this.getScrollablePosition();
        int startPixel = this.getStartPixelOfPosition(scrollablePosition) - this.getViewportPixelOffset();
        this.scrollBar.setSelection(startPixel);
    }

    void recalculateScrollBarSize() {
        int thumbSize;
        if (this.scrollBar.isDisposed()) {
            return;
        }
        int max = this.getScrollableLayerSpan() - this.getViewportPixelOffset() + this.getScrollBarOverhang();
        if (!this.scrollBar.isDisposed()) {
            this.scrollBar.setMaximum(max);
        }
        int viewportWindowSpan = this.getViewportWindowSpan();
        this.scrollBar.setPageIncrement(viewportWindowSpan);
        if (viewportWindowSpan < max && viewportWindowSpan != 0) {
            thumbSize = viewportWindowSpan;
            this.scrollBar.setEnabled(true);
            this.scrollBar.setVisible(true);
        } else {
            thumbSize = max;
            this.scrollBar.setEnabled(false);
            this.scrollBar.setVisible(false);
        }
        this.scrollBar.setThumb(thumbSize);
        this.adjustScrollBar();
    }

    protected int getScrollBarOverhang() {
        int viewportWindowSpan = this.getViewportWindowSpan();
        int scrollableLayerSpan = this.getScrollableLayerSpan();
        int viewportPixelOffset = this.getViewportPixelOffset();
        if (viewportWindowSpan <= 0 || viewportWindowSpan >= scrollableLayerSpan - viewportPixelOffset) {
            return 0;
        }
        int edgePixel = scrollableLayerSpan - viewportWindowSpan;
        int positionAtEdge = this.getPositionByPixel(edgePixel);
        int startPixelOfPositionAtEdge = this.getStartPixelOfPosition(positionAtEdge);
        int overhang = 0;
        if (edgePixel != startPixelOfPositionAtEdge) {
            overhang = this.getSpanByPosition(positionAtEdge) - (edgePixel - startPixelOfPositionAtEdge);
        }
        return overhang;
    }

    abstract int getViewportWindowSpan();

    abstract int getScrollableLayerSpan();

    abstract boolean keepScrolling();

    abstract int pageScrollDistance();

    abstract int getSpanByPosition(int var1);

    abstract int getScrollablePosition();

    abstract int getStartPixelOfPosition(int var1);

    abstract int getPositionByPixel(int var1);

    abstract int getViewportPixelOffset();

    abstract void setViewportOrigin(int var1);

    abstract SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int var1);
}

