/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ScrollBarHandlerTemplate;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.ScrollBar;

public class HorizontalScrollBarHandler
extends ScrollBarHandlerTemplate {
    public HorizontalScrollBarHandler(ViewportLayer viewportLayer, ScrollBar scrollBar) {
        super(viewportLayer, scrollBar);
    }

    int pageScrollDistance() {
        int viewportWidth;
        int widthOfColBeingScrolled = this.scrollableLayer.getColumnWidthByPosition(this.getScrollablePosition());
        int scrollWidth = widthOfColBeingScrolled > (viewportWidth = this.viewportLayer.getClientAreaWidth()) ? widthOfColBeingScrolled : viewportWidth;
        return scrollWidth;
    }

    int getSpanByPosition(int scrollablePosition) {
        return this.scrollableLayer.getColumnWidthByPosition(scrollablePosition);
    }

    int getScrollablePosition() {
        return LayerUtil.convertColumnPosition(this.viewportLayer, 0, this.scrollableLayer);
    }

    int getStartPixelOfPosition(int position) {
        return this.scrollableLayer.getStartXOfColumnPosition(position);
    }

    int getPositionByPixel(int pixelValue) {
        return this.scrollableLayer.getColumnPositionByX(pixelValue);
    }

    int getViewportPixelOffset() {
        return this.scrollableLayer.getStartXOfColumnPosition(this.viewportLayer.getMinimumOriginColumnPosition());
    }

    void setViewportOrigin(int position) {
        this.viewportLayer.invalidateHorizontalStructure();
        this.viewportLayer.setOriginColumnPosition(position);
        this.scrollBar.setIncrement(this.viewportLayer.getColumnWidthByPosition(0));
    }

    SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int eventDetail) {
        return eventDetail == 0x1000005 || eventDetail == 0x1000001 ? SelectionLayer.MoveDirectionEnum.LEFT : SelectionLayer.MoveDirectionEnum.RIGHT;
    }

    boolean keepScrolling() {
        return !this.viewportLayer.isLastColumnCompletelyDisplayed();
    }

    int getViewportWindowSpan() {
        return this.viewportLayer.getClientAreaWidth();
    }

    int getScrollableLayerSpan() {
        return this.scrollableLayer.getWidth();
    }
}

