/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.event;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowColumnPositionsEvent
extends ColumnStructuralChangeEvent {
    public ShowColumnPositionsEvent(IUniqueIndexLayer layer, Collection<Integer> columnPositions) {
        super((ILayer)layer, PositionUtil.getRanges(columnPositions));
    }

    public ShowColumnPositionsEvent(ShowColumnPositionsEvent event) {
        super(event);
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        ArrayList<StructuralDiff> columnDiffs = new ArrayList<StructuralDiff>();
        int offset = 0;
        for (Range range : this.getColumnPositionRanges()) {
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, new Range(range.start - offset, range.start - offset), range));
            offset += range.size();
        }
        return columnDiffs;
    }

    @Override
    public ShowColumnPositionsEvent cloneEvent() {
        return new ShowColumnPositionsEvent(this);
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        super.convertToLocal(localLayer);
        return true;
    }
}

