/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeColumnCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeColumnStrategy;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezePositionCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezePositionStrategy;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeSelectionCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeSelectionStrategy;
import org.eclipse.nebula.widgets.nattable.freeze.command.IFreezeCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.IFreezeCoordinatesProvider;
import org.eclipse.nebula.widgets.nattable.freeze.command.UnFreezeGridCommand;
import org.eclipse.nebula.widgets.nattable.freeze.event.FreezeEvent;
import org.eclipse.nebula.widgets.nattable.freeze.event.UnfreezeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreezeCommandHandler
extends AbstractLayerCommandHandler<IFreezeCommand> {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;

    public FreezeCommandHandler(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<IFreezeCommand> getCommandClass() {
        return IFreezeCommand.class;
    }

    @Override
    public boolean doCommand(IFreezeCommand command) {
        if (command instanceof FreezeColumnCommand) {
            FreezeColumnCommand freezeColumnCommand = (FreezeColumnCommand)command;
            FreezeColumnStrategy coordinatesProvider = new FreezeColumnStrategy(this.freezeLayer, freezeColumnCommand.getColumnPosition());
            this.handleFreezeCommand(coordinatesProvider, freezeColumnCommand.isToggle());
            return true;
        }
        if (command instanceof FreezePositionCommand) {
            FreezePositionCommand freezePositionCommand = (FreezePositionCommand)command;
            FreezePositionStrategy coordinatesProvider = new FreezePositionStrategy(this.freezeLayer, freezePositionCommand.getColumnPosition(), freezePositionCommand.getRowPosition());
            this.handleFreezeCommand(coordinatesProvider, freezePositionCommand.isToggle());
            return true;
        }
        if (command instanceof FreezeSelectionCommand) {
            FreezeSelectionStrategy coordinatesProvider = new FreezeSelectionStrategy(this.freezeLayer, this.viewportLayer, this.selectionLayer);
            this.handleFreezeCommand(coordinatesProvider, ((FreezeSelectionCommand)command).isToggle());
            return true;
        }
        if (command instanceof UnFreezeGridCommand) {
            this.handleUnfreeze();
            return true;
        }
        return false;
    }

    protected void handleFreezeCommand(IFreezeCoordinatesProvider coordinatesProvider, boolean toggle) {
        if (!this.freezeLayer.isFrozen()) {
            PositionCoordinate topLeftPosition = coordinatesProvider.getTopLeftPosition();
            PositionCoordinate bottomRightPosition = coordinatesProvider.getBottomRightPosition();
            if (topLeftPosition != null && bottomRightPosition != null) {
                this.freezeLayer.setTopLeftPosition(topLeftPosition.columnPosition, topLeftPosition.rowPosition);
                this.freezeLayer.setBottomRightPosition(bottomRightPosition.columnPosition, bottomRightPosition.rowPosition);
                this.viewportLayer.setMinimumOriginPosition(bottomRightPosition.columnPosition + 1, bottomRightPosition.rowPosition + 1);
                this.viewportLayer.fireLayerEvent(new FreezeEvent(this.viewportLayer));
            }
        } else if (toggle) {
            this.handleUnfreeze();
        }
    }

    protected void handleUnfreeze() {
        this.resetFrozenArea();
        this.viewportLayer.fireLayerEvent(new UnfreezeEvent(this.viewportLayer));
    }

    private void resetFrozenArea() {
        PositionCoordinate topLeftPosition = this.freezeLayer.getTopLeftPosition();
        this.freezeLayer.setTopLeftPosition(-1, -1);
        this.freezeLayer.setBottomRightPosition(-1, -1);
        this.viewportLayer.resetOrigin(Math.max(0, topLeftPosition.columnPosition), Math.max(0, topLeftPosition.rowPosition));
    }
}

