/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxCellEditor
extends AbstractCellEditor {
    private NatCombo combo;
    private int maxVisibleItems = 10;
    private List<?> canonicalValues;
    private IComboBoxDataProvider dataProvider;
    private Object originalCanonicalValue;

    public ComboBoxCellEditor(List<?> canonicalValues) {
        this(canonicalValues, 5);
    }

    public ComboBoxCellEditor(List<?> canonicalValues, int maxVisibleItems) {
        this.canonicalValues = canonicalValues;
        this.maxVisibleItems = maxVisibleItems;
    }

    public ComboBoxCellEditor(IComboBoxDataProvider dataProvider) {
        this(dataProvider, 5);
    }

    public ComboBoxCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems) {
        this.dataProvider = dataProvider;
        this.maxVisibleItems = maxVisibleItems;
    }

    public NatCombo getCombo() {
        return this.combo;
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue) {
        this.originalCanonicalValue = originalCanonicalValue;
        this.combo = new NatCombo(parent, this.getCellStyle(), this.maxVisibleItems);
        this.combo.setCursor(new Cursor((Device)Display.getDefault(), 19));
        this.combo.setEditMode(this.editMode);
        this.combo.setItems(this.getDisplayValues());
        if (originalCanonicalValue != null) {
            this.combo.setSelection(new String[]{this.getDisplayValue()});
        }
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                } else if (event.keyCode == 27 && event.stateMask == 0) {
                    ComboBoxCellEditor.this.close();
                }
            }
        });
        this.combo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.keyCode == 9 && event.stateMask == 131072) {
                    ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.LEFT);
                } else if (event.keyCode == 9 && event.stateMask == 0) {
                    ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.RIGHT);
                }
            }
        });
        this.combo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ComboBoxCellEditor.this.editMode == EditModeEnum.INLINE) {
                    ComboBoxCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                } else if (ComboBoxCellEditor.this.editMode == EditModeEnum.MULTI) {
                    ComboBoxCellEditor.this.combo.hideDropdownControl();
                }
            }
        });
        if (this.editMode == EditModeEnum.INLINE) {
            this.combo.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    ComboBoxCellEditor.this.close();
                }
            });
        }
        if (this.editMode == EditModeEnum.MULTI) {
            this.combo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    ComboBoxCellEditor.this.combo.hideDropdownControl();
                }
            });
        }
        return this.combo;
    }

    @Override
    public Object getCanonicalValue() {
        int selectionIndex = this.combo.getSelectionIndex();
        if (selectionIndex >= 0) {
            if (this.dataProvider != null) {
                return this.dataProvider.getValues(this.getColumnIndex(), this.getRowIndex()).get(selectionIndex);
            }
            return this.canonicalValues.get(selectionIndex);
        }
        return this.originalCanonicalValue;
    }

    public void select(int index) {
        this.combo.select(index);
    }

    @Override
    public void setCanonicalValue(Object value) {
    }

    @Override
    public void close() {
        super.close();
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.dispose();
        }
    }

    private String getDisplayValue() {
        return (String)this.getDataTypeConverter().canonicalToDisplayValue(this.layerCell, this.configRegistry, this.originalCanonicalValue);
    }

    private String[] getDisplayValues() {
        ArrayList<String> displayValues = new ArrayList<String>();
        List<?> values = this.dataProvider != null ? this.dataProvider.getValues(this.getColumnIndex(), this.getRowIndex()) : this.canonicalValues;
        for (Object canonicalValue : values) {
            displayValues.add((String)this.getDataTypeConverter().canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue));
        }
        return displayValues.toArray(ArrayUtil.STRING_TYPE_ARRAY);
    }
}

