/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.command;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiRowCommand
implements ILayerCommand {
    private Collection<RowPositionCoordinate> rowPositionCoordinates;

    protected AbstractMultiRowCommand(ILayer layer, int ... rowPositions) {
        this.setRowPositions(layer, rowPositions);
    }

    protected AbstractMultiRowCommand(AbstractMultiRowCommand command) {
        this.rowPositionCoordinates = new HashSet<RowPositionCoordinate>(command.rowPositionCoordinates);
    }

    public Collection<Integer> getRowPositions() {
        HashSet<Integer> rowPositions = new HashSet<Integer>();
        for (RowPositionCoordinate rowPositionCoordinate : this.rowPositionCoordinates) {
            rowPositions.add(rowPositionCoordinate.rowPosition);
        }
        return rowPositions;
    }

    protected final void setRowPositions(ILayer layer, int ... rowPositions) {
        this.rowPositionCoordinates = new HashSet<RowPositionCoordinate>();
        int[] nArray = rowPositions;
        int n = rowPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int rowPosition = nArray[n2];
            this.rowPositionCoordinates.add(new RowPositionCoordinate(layer, rowPosition));
            ++n2;
        }
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        HashSet<RowPositionCoordinate> convertedRowPositionCoordinates = new HashSet<RowPositionCoordinate>();
        for (RowPositionCoordinate rowPositionCoordinate : this.rowPositionCoordinates) {
            RowPositionCoordinate convertedRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(rowPositionCoordinate, targetLayer);
            if (convertedRowPositionCoordinate == null) continue;
            convertedRowPositionCoordinates.add(convertedRowPositionCoordinate);
        }
        this.rowPositionCoordinates = convertedRowPositionCoordinates;
        return this.rowPositionCoordinates.size() > 0;
    }
}

