/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintEngine;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintEngineListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ICloseablePart;
import org.eclipse.papyrus.infra.editor.welcome.IWelcomePageService;
import org.eclipse.papyrus.infra.editor.welcome.internal.Activator;
import org.eclipse.papyrus.infra.editor.welcome.internal.WelcomeLayout;
import org.eclipse.papyrus.infra.editor.welcome.internal.WelcomeTab;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.ui.runtime.DefaultDisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.DisplayEngine;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.properties.ui.xwt.XWTSection;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.views.properties.tabbed.ISection;

public class WelcomePage
implements ICloseablePart {
    private final IWelcomePageService service;
    private final Object model;
    private FormToolkit toolkit;
    private ConstraintEngine<View> constraintEngine;
    private ConstraintEngineListener constraintsListener;
    private DefaultDisplayEngine displayEngine;
    private ScrolledForm form;
    private Collection<ISection> sections;
    private WelcomeLayout welcomeLayout;
    private final CopyOnWriteArrayList<IPropertyListener> propertyListeners = new CopyOnWriteArrayList();

    public WelcomePage(IWelcomePageService service, Object model) {
        this.service = service;
        this.model = model;
    }

    public static WelcomePage getWelcomePage(Control control) {
        WelcomePage result = null;
        Control next = control;
        while (result == null && next != null) {
            if (next.getData() instanceof WelcomePage) {
                result = (WelcomePage)next.getData();
            }
            next = next.getParent();
        }
        return result;
    }

    public boolean canClose() {
        return this.service.canCloseWelcomePage();
    }

    void fireCanCloseChanged() {
        this.propertyListeners.forEach(l -> {
            try {
                l.propertyChanged((Object)this, 0x100001);
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in property listener", (Throwable)e);
            }
        });
    }

    public Composite createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.constraintEngine = PropertiesRuntime.getConstraintEngine();
        this.displayEngine = new DefaultDisplayEngine(false);
        this.attachConstraintEngine(this.constraintEngine);
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setData((Object)this);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        this.form.getBody().setLayout((Layout)layout);
        this.createSections(this.form.getBody());
        this.form.addDisposeListener(event -> this.dispose());
        return this.form;
    }

    protected void attachConstraintEngine(ConstraintEngine<? extends View> engine) {
        this.constraintsListener = event -> this.rebuildSections(this.form.getBody());
        engine.addConstraintEngineListener(this.constraintsListener);
    }

    public void dispose() {
        if (this.constraintsListener != null) {
            this.constraintEngine.removeConstraintEngineListener(this.constraintsListener);
            this.constraintsListener = null;
        }
        this.constraintEngine = null;
        if (this.displayEngine != null) {
            this.displayEngine.dispose();
            this.displayEngine = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        this.sections.forEach(ISection::dispose);
        this.sections.clear();
        if (this.welcomeLayout != null) {
            this.welcomeLayout.dispose();
            this.welcomeLayout = null;
        }
        this.propertyListeners.clear();
    }

    protected void createSections(Composite parent) {
        Set views = this.constraintEngine.getDisplayUnits(this.model);
        List welcomeContexts = PropertiesRuntime.getConfigurationManager().getContextsForPreferencePage("org.eclipse.papyrus.infra.editor.welcome.content");
        HashMap tabProxies = new HashMap();
        views.stream().filter(v -> welcomeContexts.contains(v.getContext())).flatMap(v -> v.getSections().stream()).map(s -> s.getTab()).forEach(tab -> {
            WelcomeTab existing = (WelcomeTab)tabProxies.get(tab.getId());
            if (existing != null) {
                existing.merge((Tab)tab);
            } else {
                tabProxies.put(tab.getId(), new WelcomeTab((Tab)tab));
            }
        });
        ArrayList<WelcomeTab> tabs = new ArrayList<WelcomeTab>(tabProxies.values());
        this.sections = new ArrayList<ISection>();
        this.welcomeLayout = new WelcomeLayout(parent, this.toolkit, this.service);
        this.welcomeLayout.createTabs(tabs);
        for (WelcomeTab next : tabs) {
            next.filterSections(views);
        }
        StructuredSelection selection = new StructuredSelection(this.model);
        for (WelcomeTab tab2 : tabs) {
            for (Section section : tab2.getSections()) {
                XWTSection xwtSection = new XWTSection(section, tab2.getView(section), (DisplayEngine)this.displayEngine);
                this.sections.add((ISection)xwtSection);
                xwtSection.createControls(this.welcomeLayout.getTabControl(section.getTab()), null);
                xwtSection.setInput(null, (ISelection)selection);
                xwtSection.refresh();
            }
        }
    }

    protected void rebuildSections(Composite parent) {
        this.displayEngine.invalidate();
        this.welcomeLayout.dispose();
        this.sections.forEach(ISection::dispose);
        this.sections.clear();
        this.createSections(parent);
        parent.layout();
    }

    void reset() {
        this.welcomeLayout.resetLayoutModel();
    }

    void layout() {
        this.welcomeLayout.layout();
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.propertyListeners.addIfAbsent(listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.propertyListeners.remove(listener);
    }
}

