/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.utils;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class QualifiedNameUtils {
    public static final String QN_SEPARATOR_FOR_PROPERTIES = "__";

    public static String getQualifiedName(EObject eObject) {
        StringBuilder result = new StringBuilder();
        EObject parent = eObject;
        boolean hasNotFoundName = false;
        while (parent != null && !hasNotFoundName) {
            if (parent.eResource().getURI().equals(eObject.eResource().getURI())) {
                Object featureValue;
                hasNotFoundName = true;
                EStructuralFeature feature = parent.eClass().getEStructuralFeature("name");
                if (feature != null && (featureValue = parent.eGet(feature)) instanceof String) {
                    result = QualifiedNameUtils.appendQualifiedName(result, (String)featureValue);
                    hasNotFoundName = false;
                }
            }
            parent = parent.eContainer();
        }
        if (hasNotFoundName && eObject.eResource() instanceof XMIResource) {
            result = new StringBuilder();
            result.append(((XMIResource)eObject.eResource()).getID(eObject));
        }
        return result.toString();
    }

    public static EObject getOwner(Diagram diagram) {
        Object value;
        EStructuralFeature ownerFeature;
        Style pvs = QualifiedNameUtils.getPapyrusViewStyle(diagram);
        if (pvs != null && (ownerFeature = QualifiedNameUtils.getOwnerFeature(pvs)) != null && (value = pvs.eGet(ownerFeature)) != null && value instanceof EObject) {
            return (EObject)value;
        }
        return diagram.getElement();
    }

    private static EStructuralFeature getOwnerFeature(Style style) {
        EStructuralFeature feature = null;
        Iterator existingFeatures = style.eClass().getEAllStructuralFeatures().iterator();
        while (existingFeatures.hasNext() && feature == null) {
            EStructuralFeature currentFeature = (EStructuralFeature)existingFeatures.next();
            if (!currentFeature.getName().equals("owner")) continue;
            feature = currentFeature;
        }
        return feature;
    }

    private static final Style getPapyrusViewStyle(Diagram diagram) {
        Style papyrusViewStyle = null;
        Iterator ownedStyles = diagram.getStyles().iterator();
        while (ownedStyles.hasNext() && papyrusViewStyle == null) {
            Object ownedStyle = ownedStyles.next();
            if (!(ownedStyle instanceof Style) || !((Style)ownedStyle).eClass().getName().equals("PapyrusViewStyle")) continue;
            papyrusViewStyle = (Style)ownedStyle;
        }
        return papyrusViewStyle;
    }

    private static StringBuilder appendQualifiedName(StringBuilder initialStringBuilder, String toAdd) {
        StringBuilder result = new StringBuilder();
        result.append(toAdd);
        if (!initialStringBuilder.toString().isEmpty()) {
            result.append(QN_SEPARATOR_FOR_PROPERTIES);
        }
        result.append((CharSequence)initialStringBuilder);
        return result;
    }

    public static Diagram getDiagram(Resource resource, String diagramName, String qualifiedName) {
        if (diagramName != null && !diagramName.isEmpty()) {
            for (EObject element : resource.getContents()) {
                Diagram diagram;
                if (!(element instanceof Diagram) || !diagramName.equals((diagram = (Diagram)element).getName()) || qualifiedName != null && !qualifiedName.isEmpty() && !QualifiedNameUtils.getQualifiedName(diagram.getElement()).equals(qualifiedName)) continue;
                return diagram;
            }
        }
        return null;
    }

    public static Table getTable(Resource resource, String tableName, String qualifiedName) {
        if (tableName != null && !tableName.isEmpty()) {
            for (EObject element : resource.getContents()) {
                Table table;
                if (!(element instanceof Table) || !tableName.equals((table = (Table)element).getName()) || qualifiedName != null && !qualifiedName.isEmpty() && !QualifiedNameUtils.getQualifiedName(table.getOwner()).equals(qualifiedName)) continue;
                return table;
            }
        }
        return null;
    }
}

