/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.internal.sessions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.sirius.editor.internal.sessions.PapyrusSession;
import org.eclipse.papyrus.sirius.editor.internal.sessions.services.IPapyrusSessionFactory;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.session.SessionFactoryImpl;
import org.eclipse.sirius.viewpoint.DAnalysis;

public class PapyrusSessionFactory
extends SessionFactoryImpl
implements IPapyrusSessionFactory {
    @Override
    public final Session createPapyrusSession(URI sessionResourceURI, TransactionalEditingDomain ted) throws CoreException {
        return this.createPapyrusSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor(), ted);
    }

    @Override
    public Session createPapyrusSession(URI sessionResourceURI, IProgressMonitor monitor, TransactionalEditingDomain ted) throws CoreException {
        this.preparePapyrusEditingDomain(sessionResourceURI, ted);
        boolean alreadyExistingResource = ted.getResourceSet().getURIConverter().exists(sessionResourceURI, null);
        Session session = null;
        session = alreadyExistingResource ? this.loadSessionModelResource(sessionResourceURI, ted, monitor) : this.createSessionResource(sessionResourceURI, ted, true, monitor);
        return session;
    }

    @Override
    public Session createDefaultPapyrusSession(URI sessionResourceURI, TransactionalEditingDomain ted) throws CoreException {
        return this.createPapyrusSession(sessionResourceURI, (IProgressMonitor)new NullProgressMonitor(), ted);
    }

    protected final TransactionalEditingDomain preparePapyrusEditingDomain(URI sessionResourceURI, TransactionalEditingDomain transactionalEditingDomain) {
        ResourceSet set = transactionalEditingDomain.getResourceSet();
        set.getLoadOptions().put("SIRIUS_USE_URI_FRAGMENT_AS_ID", true);
        this.configureDomain(transactionalEditingDomain, sessionResourceURI);
        return transactionalEditingDomain;
    }

    protected Session createSession(DAnalysis analysis, TransactionalEditingDomain transactionalEditingDomain) {
        if (transactionalEditingDomain.getResourceSet() instanceof ModelSet) {
            return new PapyrusSession(analysis, transactionalEditingDomain);
        }
        return super.createSession(analysis, transactionalEditingDomain);
    }
}

