/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.ILabelConstants;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.UMLInternationalizedComplexLabelSwitch;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.UMLKeywordLabelSwitch;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class UMLLabelService {
    private final UMLKeywordLabelSwitch keywordProvider = new UMLKeywordLabelSwitch();
    private final UMLInternationalizedComplexLabelSwitch nameProvider = new UMLInternationalizedComplexLabelSwitch();

    private boolean isShowingQualifiedName(DDiagram diagram) {
        long count = diagram.getActivatedLayers().stream().filter(layer -> "QualifiedNameLayer".equals(layer.getName())).count();
        return count == 1L;
    }

    private boolean isShowingAppliedStereotype(DDiagram diagram) {
        long count = diagram.getActivatedLayers().stream().filter(layer -> "AppliedStereotypeLayer".equals(layer.getName())).count();
        return count == 1L;
    }

    public String buildSingleLineLabel(Element element, DDiagram diagram) {
        return this.buildLabel(element, diagram, false, false);
    }

    public String buildMultilineLabel(Element element, DDiagram diagram) {
        return this.buildLabel(element, diagram, true, this.isShowingQualifiedName(diagram));
    }

    private final String buildStereotypeLabel(Element element) {
        StringBuilder builder = new StringBuilder();
        Iterator iter = element.getAppliedStereotypes().iterator();
        if (iter.hasNext()) {
            builder.append("\u00ab");
        }
        while (iter.hasNext()) {
            Stereotype current = (Stereotype)iter.next();
            builder.append(UMLLabelInternationalization.getInstance().getKeyword(current));
            if (!iter.hasNext()) continue;
            builder.append(",");
            builder.append(" ");
        }
        if (builder.length() > 0) {
            builder.append("\u00bb");
        }
        return builder.toString();
    }

    private final String buildLabel(Element element, DDiagram diagram, boolean multiline, boolean useQualifiedName) {
        this.nameProvider.useQualifiedName(useQualifiedName);
        String keyword = (String)this.keywordProvider.doSwitch((EObject)element);
        String stereotypeLabel = this.isShowingAppliedStereotype(diagram) ? this.buildStereotypeLabel(element) : null;
        String name = (String)this.nameProvider.doSwitch((EObject)element);
        StringBuilder builder = new StringBuilder();
        if (keyword != null && !keyword.isEmpty()) {
            builder.append(keyword);
            if (multiline) {
                builder.append(ILabelConstants.NL);
            } else {
                builder.append(" ");
            }
        }
        if (stereotypeLabel != null && !stereotypeLabel.isEmpty()) {
            builder.append(stereotypeLabel);
            if (multiline) {
                builder.append(ILabelConstants.NL);
            } else {
                builder.append(" ");
            }
        }
        if (name != null && !name.isEmpty()) {
            builder.append(name);
        }
        return builder.toString();
    }
}

