/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.query.java.core.internal.evaluator;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.core.internal.query.QueryUtils;
import org.eclipse.papyrus.emf.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.papyrus.emf.facet.efacet.core.query.IQueryImplementationFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.papyrus.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.papyrus.emf.facet.query.java.core.internal.evaluator.JavaQueryImplementation;
import org.eclipse.papyrus.emf.facet.query.java.core.internal.plugin.Activator;
import org.eclipse.papyrus.emf.facet.query.java.metamodel.v0_2_0.javaquery.JavaQuery;
import org.eclipse.papyrus.emf.facet.query.java.metamodel.v0_2_0.javaquery.JavaQueryPackage;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.osgi.framework.Bundle;

public class JavaQueryImplementationFactory
implements IQueryImplementationFactory {
    public IQueryImplementation create(Query query, Bundle bundle, IDerivedTypedElementManager manager) throws DerivedTypedElementException {
        if (!(query instanceof JavaQuery)) {
            throw new IllegalArgumentException("The given DerivedTypedElement does not have a JavaQuery");
        }
        JavaQuery javaQuery = (JavaQuery)query;
        if (bundle == null) {
            throw new DerivedTypedElementException("Java query implementation class '" + javaQuery.getClass().getName() + "' should be created within a bundle.");
        }
        JavaQueryImplementation javaQueryEvaluator = null;
        try {
            String className = javaQuery.getImplementationClassName();
            if (className == null || className.length() == 0) {
                throw new DerivedTypedElementException("The Java query's implementationClassName must not be empty");
            }
            Class javaQueryClass = bundle.loadClass(className);
            if (!IJavaQuery2.class.isAssignableFrom(javaQueryClass)) {
                throw new Exception("Java query implementation class '" + className + "' does not implement " + IJavaQuery2.class.getSimpleName() + ".");
            }
            javaQueryEvaluator = JavaQueryImplementationFactory.createJavaQueryImpl(javaQueryClass);
            javaQueryEvaluator.setCheckResultType(true);
        }
        catch (Exception e) {
            DerivedTypedElementException queryException = new DerivedTypedElementException("The bundle " + bundle.getSymbolicName() + " failed to load the java query: " + QueryUtils.getQueryDescription((Query)javaQuery), (Throwable)e);
            Logger.logError((Throwable)queryException, (Plugin)Activator.getDefault());
            throw queryException;
        }
        return javaQueryEvaluator;
    }

    private static JavaQueryImplementation createJavaQueryImpl(Class<?> javaQueryClass) throws InstantiationException, IllegalAccessException {
        IJavaQuery2 javaQueryInst = (IJavaQuery2)javaQueryClass.newInstance();
        JavaQueryImplementation javaQueryEvaluator = new JavaQueryImplementation(javaQueryInst);
        return javaQueryEvaluator;
    }

    public EClass getManagedQueryType() {
        return JavaQueryPackage.eINSTANCE.getJavaQuery();
    }
}

