/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.stereotypeapplication.internal;

import java.util.Optional;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFStereotypeApplicationDescription;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.stereotypeapplication.internal.StereotypeApplicationController;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.AppliedStereotypeCompositeWithView;
import org.eclipse.papyrus.uml.properties.widgets.StereotypePropertyEditor;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;

public class StereotypeApplicationLifecycleManager
implements IEEFLifecycleManager {
    protected StyledText label;
    protected CLabel help;
    private EEFStereotypeApplicationDescription description;
    private IInterpreter interpreter;
    private IVariableManager variableManager;
    private EditingContextAdapter editingContextAdapter;
    private Composite mainComposite;
    private Element target;
    private AppliedStereotypeCompositeWithView stereotypeComposite;
    private MouseTrackListener mouseTrackListener;
    private StereotypeApplicationController controller;

    public StereotypeApplicationLifecycleManager(EEFStereotypeApplicationDescription controlDescription, Element target, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        this.description = controlDescription;
        this.target = target;
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.editingContextAdapter = editingContextAdapter;
    }

    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        Composite composite = parent;
        composite = widgetFactory.createComposite(parent);
        int numColumn = 3;
        GridLayout layout = new GridLayout(numColumn, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 1;
        composite.setLayoutData((Object)layoutData);
        this.label = widgetFactory.createStyledText(composite, 8);
        this.label.setEditable(false);
        this.label.setCaret(null);
        this.label.setCursor(Display.getCurrent().getSystemCursor(0));
        this.label.setDoubleClickEnabled(false);
        this.label.setLayoutData((Object)new GridData(2));
        String labelExpression = Optional.ofNullable(this.description.getLabelExpression()).orElse("");
        if (!labelExpression.isEmpty()) {
            String result = (String)EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).evaluate(labelExpression);
            this.label.setText(result);
        }
        this.help = widgetFactory.createCLabel(composite, "");
        if (!Util.isBlank((String)this.description.getHelpExpression())) {
            this.help.setImage(EEFIdeUiPlugin.getPlugin().getImageRegistry().get("icons/full/help.gif"));
            this.help.setLayoutData((Object)new GridData(2));
            this.help.setToolTipText("");
        }
        this.mainComposite = new Composite(composite, 0);
        GridLayout mainLayout = new GridLayout(2, false);
        this.mainComposite.setLayout((Layout)mainLayout);
        GridData mainLayoutData = new GridData(4, 0x1000000, true, false);
        this.mainComposite.setLayoutData((Object)mainLayoutData);
        this.stereotypeComposite = new AppliedStereotypeCompositeWithView(this.mainComposite);
        this.stereotypeComposite.setElement(this.target);
        StereotypePropertyEditor propertyEditor = new StereotypePropertyEditor(this.mainComposite, 0, this.stereotypeComposite);
        this.stereotypeComposite.setPropertySelectionChangeListener((ISelectionChangedListener)propertyEditor);
        this.stereotypeComposite.createContent(this.mainComposite, AbstractEditor.factory);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 200;
        this.stereotypeComposite.setLayoutData((Object)data);
        data = new GridData(4, 4, true, false);
        data.heightHint = 200;
        propertyEditor.setLayoutData(data);
        this.controller = new StereotypeApplicationController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    public void aboutToBeShown() {
        this.getController().onNewHelp(value -> {
            if (!(this.help == null || this.help.isDisposed() || this.help.getText() != null && this.help.getText().equals(value))) {
                this.help.setToolTipText(Optional.ofNullable(value).orElse(Messages.AbstractEEFWidgetLifecycleManager_noDescriptionAvailable));
            }
        });
        if (this.help != null) {
            this.mouseTrackListener = new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                    StereotypeApplicationLifecycleManager.this.getController().computeHelp();
                }

                public void mouseExit(MouseEvent e) {
                }

                public void mouseEnter(MouseEvent e) {
                }
            };
            this.help.addMouseTrackListener(this.mouseTrackListener);
        }
    }

    public void refresh() {
        this.stereotypeComposite.refresh();
    }

    public void aboutToBeHidden() {
        if (this.help != null && !this.help.isDisposed()) {
            this.help.removeMouseTrackListener(this.mouseTrackListener);
        }
        this.getController().removeNewLabelConsumer();
    }

    public void dispose() {
    }

    public StereotypeApplicationController getController() {
        return this.controller;
    }
}

