/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ext.widgets.reference.eefextwidgetsreference.EEFExtReferenceDescription;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.AbstractEEFExtReferenceLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtReferenceUIPlugin;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtSingleReferenceLifecycleManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFExtEditableReferenceDescription;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.Activator;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal.CustomUMLContentProvider;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal.EditableReferenceController;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.editablereference.internal.PapyrusEEFExtEObjectCreationWizard;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class SingleEditableReferenceLifecycleManager
extends EEFExtSingleReferenceLifecycleManager {
    private static final String CREATE_DIALOG_TITLE = "Create a new UML Element";
    private static final String BROWSE_DIALOG_TITLE = "Browse ";
    private static final String EDIT_BUTTON_TOOLTIP = "Edit the selected value";
    protected Button editButton;
    protected AbstractEEFExtReferenceLifecycleManager.ButtonSelectionListener editButtonListener;

    public SingleEditableReferenceLifecycleManager(EEFExtEditableReferenceDescription description, EObject target, EReference eReference, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super((EEFExtReferenceDescription)description, target, eReference, variableManager, interpreter, editingContextAdapter);
    }

    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        super.createMainControl(parent, formContainer);
        this.controller = new EditableReferenceController((IEEFLifecycleManager)this, this.getWidgetDescription(), this.variableManager, this.interpreter, this.editingContextAdapter, this.isEnabled());
    }

    protected EditableReferenceController getController() {
        return (EditableReferenceController)this.controller;
    }

    protected void setEnabled(boolean isEnabled) {
        boolean referenceExists;
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(isEnabled);
        }
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.setEnabled(isEnabled);
        }
        boolean bl = referenceExists = this.target.eGet((EStructuralFeature)this.eReference) != null;
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            if (referenceExists) {
                this.removeButton.setEnabled(isEnabled);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        if (this.editButton != null && !this.editButton.isDisposed()) {
            if (referenceExists) {
                this.editButton.setEnabled(isEnabled);
            } else {
                this.editButton.setEnabled(false);
            }
        }
    }

    protected EEFExtEditableReferenceDescription getWidgetDescription() {
        return (EEFExtEditableReferenceDescription)this.description;
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.initializeEditButton();
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        this.removeListener(this.editButton, this.editButtonListener);
    }

    protected void createButtons(Composite parent) {
        int enabledButtons = this.getButtonsNumber();
        parent.setLayout((Layout)new GridLayout(enabledButtons, true));
        if (!this.eReference.isContainment()) {
            Image browseImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Browse_16x16.gif"));
            this.browseButton = this.createButton(parent, browseImage);
        }
        Image addImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Add_16x16.gif"));
        this.addButton = this.createButton(parent, addImage);
        if (!this.eReference.isRequired() && !this.eReference.isContainer()) {
            Image removeImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Delete_16x16.gif"));
            this.removeButton = this.createButton(parent, removeImage);
        }
        Image editImage = ExtendedImageRegistry.INSTANCE.getImage((Object)Activator.getDefault().getImage("Edit_16x16.gif"));
        this.editButton = this.createButton(parent, editImage);
    }

    protected int getButtonsNumber() {
        int enabledButtons = 0;
        if (!this.eReference.isContainment()) {
            ++enabledButtons;
        }
        if (!this.eReference.isRequired() && !this.eReference.isContainer()) {
            ++enabledButtons;
        }
        return enabledButtons += 2;
    }

    protected void initializeEditButton() {
        this.editButtonListener = new AbstractEEFExtReferenceLifecycleManager.ButtonSelectionListener(this.editingContextAdapter, () -> this.editButtonCallback());
        this.editButton.addSelectionListener((SelectionListener)this.editButtonListener);
        this.editButton.setToolTipText(EDIT_BUTTON_TOOLTIP);
    }

    protected void editButtonCallback() {
        Object value;
        if (this.target != null && (value = this.target.eGet((EStructuralFeature)this.eReference)) instanceof EObject) {
            EObject eObject = (EObject)value;
            int returnCode = this.getController().getPropertiesUtils().displayEditionProperties(this.editingContextAdapter, eObject, this.variableManager, this.interpreter);
            if (returnCode == 0) {
                this.refreshWithResize();
            }
        }
    }

    protected void createLabel(Composite parent) {
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        --parentLayout.numColumns;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Composite horizontalIntermediateComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        horizontalIntermediateComposite.setLayout((Layout)gridLayout);
        horizontalIntermediateComposite.setLayoutData((Object)gridData);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalAlignment = 4;
        Composite clickableComposite = new Composite(horizontalIntermediateComposite, 0);
        GridLayout clickableGridLayout = new GridLayout(2, false);
        clickableGridLayout.verticalSpacing = 0;
        clickableGridLayout.marginHeight = 0;
        clickableComposite.setLayout((Layout)clickableGridLayout);
        clickableComposite.setLayoutData((Object)gd);
        super.createLabel(clickableComposite);
        MouseAdapter listener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (SingleEditableReferenceLifecycleManager.this.isEnabled()) {
                    SingleEditableReferenceLifecycleManager.this.editingContextAdapter.performModelChange(() -> SingleEditableReferenceLifecycleManager.this.editButtonCallback());
                }
            }
        };
        clickableComposite.addMouseListener((MouseListener)listener);
        if (this.image != null) {
            this.image.addMouseListener((MouseListener)listener);
        }
        if (this.text != null) {
            this.text.addMouseListener((MouseListener)listener);
        }
        if (this.hyperlink != null) {
            this.hyperlink.addMouseListener((MouseListener)listener);
        }
    }

    public void refresh() {
        super.refresh();
        LabelProviderService service = null;
        Object value = this.target.eGet((EStructuralFeature)this.eReference);
        if (value instanceof EObject) {
            ILabelProvider labelProvider;
            try {
                ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.target);
                service = (LabelProviderService)registry.getService(LabelProviderService.class);
            }
            catch (ServiceException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls", "Unable to find the corresponding service."));
            }
            if (service != null && (labelProvider = service.getLabelProvider((Object)this.target)) != null) {
                String onClickExpression = Optional.ofNullable(this.description.getOnClickExpression()).orElse("");
                if (onClickExpression.isEmpty()) {
                    this.text.setText(labelProvider.getText(value));
                } else {
                    this.hyperlink.setText(labelProvider.getText(value));
                    this.hyperlink.setData(value);
                }
            }
        }
        this.variableManager.put("selection", this.target.eGet((EStructuralFeature)this.eReference));
        this.setEnabled(this.isEnabled());
    }

    private void refreshWithResize() {
        this.refresh();
        this.text.requestLayout();
    }

    private void updateTargetReference(Object newRef) {
        String browseExpression = Optional.ofNullable(this.getController().getBrowseExpression()).orElse("");
        if (!browseExpression.isEmpty()) {
            this.variableManager.put("selection", newRef);
            EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).call(browseExpression);
        } else {
            this.target.eSet((EStructuralFeature)this.eReference, newRef);
        }
    }

    private EObject evaluateCreateExpression() {
        IEvaluationResult result;
        EObject objectCreated = null;
        String createExpression = this.getWidgetDescription().getCreateExpression();
        if (createExpression != null && !createExpression.isBlank() && (result = this.interpreter.evaluateExpression(this.variableManager.getVariables(), createExpression)).success()) {
            objectCreated = (EObject)result.getValue();
        }
        return objectCreated;
    }

    protected void addButtonCallback() {
        List types = this.getController().getPropertiesUtils().getAllPossibleTypes(this.composedAdapterFactory, this.editingContextAdapter, this.target, this.eReference);
        int returnCode = 1;
        EObject objectCreated = null;
        if (types.size() == 1 && this.eReference.isContainment()) {
            this.variableManager.put("newElementTypeName", (Object)((EObject)types.get(0)).eClass().getName());
            this.variableManager.put("newElementContainer", (Object)this.target);
            this.variableManager.put("newElementContainerFeatureName", (Object)this.eReference.getName());
            objectCreated = this.evaluateCreateExpression();
            if (objectCreated != null) {
                returnCode = this.getController().getPropertiesUtils().displayCreationProperties(this.editingContextAdapter, objectCreated, this.variableManager, this.interpreter);
            }
        } else {
            PapyrusEEFExtEObjectCreationWizard wizard = new PapyrusEEFExtEObjectCreationWizard(this.target, this.eReference, this.editingContextAdapter);
            wizard.setWindowTitle(CREATE_DIALOG_TITLE);
            WizardDialog wizardDialog = new WizardDialog(this.image.getShell(), (IWizard)wizard);
            returnCode = wizardDialog.open();
            if (returnCode != 0) {
                throw new OperationCanceledException();
            }
            this.variableManager.put("newElementTypeName", (Object)wizard.getSelectedTypeName());
            this.variableManager.put("newElementContainer", (Object)wizard.getSelectedEContainer());
            this.variableManager.put("newElementContainerFeatureName", (Object)wizard.getSelectedEContainerFeature().getName());
            objectCreated = this.evaluateCreateExpression();
            if (objectCreated != null) {
                returnCode = this.getController().getPropertiesUtils().displayCreationProperties(this.editingContextAdapter, objectCreated, this.variableManager, this.interpreter);
                if (returnCode != 0) {
                    throw new OperationCanceledException();
                }
                this.updateTargetReference(objectCreated);
            }
        }
        if (returnCode != 0) {
            throw new OperationCanceledException();
        }
        this.refreshWithResize();
    }

    protected void browseButtonCallback() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
        UMLFilteredLabelProvider labelProvider = new UMLFilteredLabelProvider();
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        CustomUMLContentProvider provider = new CustomUMLContentProvider(this.target, this.eReference);
        dialog.setContentProvider((ITreeContentProvider)provider);
        dialog.setInitialElementSelections(Collections.singletonList(null));
        dialog.setTitle(BROWSE_DIALOG_TITLE + this.eReference.getEType().getName());
        if (dialog.open() != 0 || dialog.getResult().length != 1) {
            throw new OperationCanceledException();
        }
        Object[] result = dialog.getResult();
        this.updateTargetReference(result[0]);
        this.refreshWithResize();
    }

    protected void removeButtonCallback() {
        String removeExpression = this.getWidgetDescription().getRemoveExpression();
        EvalFactory.of((IInterpreter)this.interpreter, (IVariableManager)this.variableManager).call(removeExpression);
        this.refreshWithResize();
    }

    protected void initializeRemoveButton() {
        if (!this.eReference.isRequired() && !this.eReference.isContainer()) {
            super.initializeRemoveButton();
        }
    }
}

