/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.utils.ResourceUtils;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

abstract class PlatformHelper {
    private static final String ECORE_URI_MAPPING_EXTENSION_POINT = "org.eclipse.emf.ecore.uri_mapping";
    private static final String E_EXTENSION = "extension";
    private static final String A_POINT = "point";
    private static final String E_MAPPING = "mapping";
    private static final String A_SOURCE = "source";
    private static final String A_TARGET = "target";
    static final PlatformHelper INSTANCE;

    static {
        PlatformHelper instance;
        try {
            instance = new PDEHelper();
        }
        catch (Exception e) {
            instance = new InstallHelper();
        }
        INSTANCE = instance;
    }

    PlatformHelper() {
    }

    abstract Collection<String> getPlatformBundleIDs();

    abstract Map<String, String> getLocalUriMappings(IProject var1);

    EPackage.Registry createWorkspacePackageRegistry() {
        return new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
    }

    private static final class InstallHelper
    extends PlatformHelper {
        private static final int AVAILABLE = 44;

        private InstallHelper() {
        }

        @Override
        Collection<String> getPlatformBundleIDs() {
            HashSet<String> result = new HashSet<String>();
            FrameworkWiring wiring = (FrameworkWiring)Platform.getBundle((String)"system.bundle").adapt(FrameworkWiring.class);
            Collection bundleIdentities = wiring.findProviders(ModuleContainer.createRequirement((String)"osgi.identity", Collections.emptyMap(), Collections.emptyMap()));
            for (BundleCapability next : bundleIdentities) {
                Bundle bundle = next.getRevision().getBundle();
                if ((bundle.getState() & 0x2C) == 0) continue;
                result.add(bundle.getSymbolicName());
            }
            return result;
        }

        @Override
        Map<String, String> getLocalUriMappings(IProject project) {
            IFile pluginXML = project.getFile("plugin.xml");
            if (!pluginXML.isAccessible()) {
                return Map.of();
            }
            final HashMap<String, String> result = new HashMap<String, String>();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream input = pluginXML.getContents();){
                    SAXParserFactory.newInstance().newSAXParser().parse(input, (DefaultHandler)new DefaultHandler2(){
                        private boolean inMappings;

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                            if (PlatformHelper.E_EXTENSION.equals(qName) && PlatformHelper.ECORE_URI_MAPPING_EXTENSION_POINT.equals(attributes.getValue(PlatformHelper.A_POINT))) {
                                this.inMappings = true;
                            } else if (this.inMappings && PlatformHelper.E_MAPPING.equals(qName)) {
                                String source = attributes.getValue(PlatformHelper.A_SOURCE);
                                String target = attributes.getValue(PlatformHelper.A_TARGET);
                                if (source != null && !source.isBlank() && target != null && !target.isBlank()) {
                                    result.put(source, target);
                                }
                            }
                        }

                        @Override
                        public void endElement(String uri, String localName, String qName) throws SAXException {
                            if (PlatformHelper.E_EXTENSION.equals(qName)) {
                                this.inMappings = false;
                            }
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
                Activator.log.error("Failed to parse plugin.xml in project" + project.getName(), e);
            }
            return result;
        }
    }

    private static final class PDEHelper
    extends PlatformHelper {
        private static final String GENERATED_PACKAGE_EXTPOINT = "org.eclipse.emf.ecore.generated_package";
        private static final String DYNAMIC_PACKAGE_EXTPOINT = "org.eclipse.emf.ecore.dynamic_package";
        private static final String PACKAGE_EXTELEM = "package";
        private static final String RESOURCE_EXTELEM = "resource";
        private static final String URI_EXTATT = "uri";
        private static final String GEN_MODEL_EXTATT = "genModel";
        private static final String LOCATION_EXTATT = "location";
        private static final String GEN_MODEL = "GenModel";
        private static final String GEN_PACKAGES = "genPackages";
        private static final String ECORE_PACKAGE = "ecorePackage";

        private PDEHelper() {
        }

        @Override
        Collection<String> getPlatformBundleIDs() {
            IPluginModelBase[] pluginModels = PluginRegistry.getActiveModels();
            HashSet<String> result = new HashSet<String>();
            IPluginModelBase[] iPluginModelBaseArray = pluginModels;
            int n = pluginModels.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase next = iPluginModelBaseArray[n2];
                if (next.getBundleDescription() != null) {
                    result.add(next.getBundleDescription().getSymbolicName());
                }
                ++n2;
            }
            return result;
        }

        @Override
        Map<String, String> getLocalUriMappings(IProject project) {
            HashMap<String, String> localMappings = new HashMap<String, String>();
            IPluginModelBase model = PluginRegistry.findModel((String)project.getName());
            if (model == null) {
                return localMappings;
            }
            IPluginExtension[] iPluginExtensionArray = model.getExtensions().getExtensions();
            int n = iPluginExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension extension = iPluginExtensionArray[n2];
                if (Objects.equals(extension.getPoint(), PlatformHelper.ECORE_URI_MAPPING_EXTENSION_POINT)) {
                    Arrays.stream(extension.getChildren()).filter(IPluginElement.class::isInstance).map(IPluginElement.class::cast).filter(element -> Objects.equals(PlatformHelper.E_MAPPING, element.getName())).forEach(element -> this.mapURI((Map<String, String>)localMappings, (IPluginElement)element));
                }
                ++n2;
            }
            return localMappings;
        }

        private void mapURI(Map<String, String> mappings, IPluginElement element) {
            String source = this.getAttribute(element, PlatformHelper.A_SOURCE);
            String target = this.getAttribute(element, PlatformHelper.A_TARGET);
            if (source != null && target != null) {
                mappings.put(source, target);
            }
        }

        @Override
        EPackage.Registry createWorkspacePackageRegistry() {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.setURIConverter(ResourceUtils.createWorkspaceAwareURIConverter());
            EPackageRegistryImpl result = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
            HashMap<String, URI> models = new HashMap<String, URI>();
            IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getWorkspaceModels();
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                IPluginExtension[] iPluginExtensionArray = model.getExtensions().getExtensions();
                int n3 = iPluginExtensionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginExtension extension = iPluginExtensionArray[n4];
                    switch (extension.getPoint()) {
                        case "org.eclipse.emf.ecore.generated_package": {
                            Arrays.stream(extension.getChildren()).filter(IPluginElement.class::isInstance).map(IPluginElement.class::cast).filter(element -> Objects.equals(PACKAGE_EXTELEM, element.getName())).forEach(element -> this.mapPackageRegistration((Map<String, URI>)models, (IPluginElement)element, URI_EXTATT, GEN_MODEL_EXTATT, genmodel -> this.getURI(model, (String)genmodel, false)));
                            break;
                        }
                        case "org.eclipse.emf.ecore.dynamic_package": {
                            Arrays.stream(extension.getChildren()).filter(IPluginElement.class::isInstance).map(IPluginElement.class::cast).filter(element -> Objects.equals(RESOURCE_EXTELEM, element.getName())).forEach(element -> this.mapPackageRegistration((Map<String, URI>)models, (IPluginElement)element, URI_EXTATT, LOCATION_EXTATT, location -> this.getURI(model, (String)location, true)));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            models.forEach((arg_0, arg_1) -> this.lambda$14((EPackage.Registry)result, (ResourceSet)resourceSet, arg_0, arg_1));
            return result;
        }

        private void mapPackageRegistration(Map<String, URI> models, IPluginElement element, String nsURIAttribute, String modelAttribute, Function<String, URI> uriFunction) {
            String nsURI = this.getAttribute(element, nsURIAttribute);
            String modelLocation = this.getAttribute(element, modelAttribute);
            URI modelURI = null;
            if (modelLocation != null && nsURI != null) {
                modelURI = uriFunction.apply(modelLocation);
            }
            if (modelURI != null) {
                models.put(nsURI, modelURI);
            }
        }

        private String getAttribute(IPluginElement element, String name) {
            IPluginAttribute attribute = element.getAttribute(name);
            return attribute == null ? null : attribute.getValue();
        }

        private URI getURI(IPluginModelBase plugin, String path, boolean withFragment) {
            int hash;
            URI result;
            try {
                result = URI.createURI((String)path, (boolean)true);
                if (!result.isRelative()) {
                    return result;
                }
            }
            catch (Exception exception) {}
            while (!path.isEmpty() && (path.startsWith("/") || path.startsWith("\\"))) {
                path = path.substring(1);
            }
            String fragment = null;
            if (withFragment && (hash = path.lastIndexOf(35)) >= 0) {
                fragment = path.substring(hash + 1);
                path = path.substring(0, hash);
            }
            path = String.format("%s/%s", plugin.getPluginBase().getId(), path);
            result = URI.createPlatformResourceURI((String)path, (boolean)true);
            if (fragment != null) {
                result = result.appendFragment(fragment);
            }
            return result;
        }

        private EPackage.Descriptor createEPackageDescriptor(final ResourceSet resourceSet, final URI modelURI) {
            return new EPackage.Descriptor(){

                public EPackage getEPackage() {
                    return this.loadEPackage(resourceSet, modelURI);
                }

                public EFactory getEFactory() {
                    EPackage ePackage = this.getEPackage();
                    return ePackage == null ? null : ePackage.getEFactoryInstance();
                }
            };
        }

        private EPackage loadEPackage(ResourceSet resourceSet, URI modelURI) {
            EPackage result = null;
            try {
                if (modelURI.hasFragment()) {
                    EObject object = resourceSet.getEObject(modelURI, true);
                    if (object instanceof EPackage) {
                        result = (EPackage)object;
                    }
                } else {
                    Resource resource = resourceSet.getResource(modelURI, true);
                    if (resource != null && resource.isLoaded() && !resource.getContents().isEmpty()) {
                        EObject object = (EObject)resource.getContents().get(0);
                        if (object instanceof EPackage) {
                            result = (EPackage)object;
                        } else if (GEN_MODEL.equals(object.eClass().getName()) && object.eClass().getEStructuralFeature(GEN_PACKAGES) != null) {
                            EStructuralFeature genPackagesRef = object.eClass().getEStructuralFeature(GEN_PACKAGES);
                            EObject genPackage = (EObject)((EList)object.eGet(genPackagesRef)).get(0);
                            EStructuralFeature ecorePackageRef = genPackage.eClass().getEStructuralFeature(ECORE_PACKAGE);
                            result = (EPackage)genPackage.eGet(ecorePackageRef);
                        }
                    }
                }
                if (result != null) {
                    result.eResource().setURI(URI.createURI((String)result.getNsURI()));
                }
            }
            catch (Exception e) {
                Activator.log.error("Failed to load Ecore package from workspace.", (Throwable)e);
            }
            return result;
        }

        private /* synthetic */ void lambda$14(EPackage.Registry registry, ResourceSet resourceSet, String uri, URI modelURI) {
            if (!EPackage.Registry.INSTANCE.containsKey((Object)uri)) {
                registry.put((Object)uri, (Object)this.createEPackageDescriptor(resourceSet, modelURI));
            }
        }
    }
}

