/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.file.AbstractFileEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IBuildEditor;

public class BuildEditor
extends AbstractFileEditor
implements IBuildEditor {
    private Properties buildConfig;
    private IFile buildFile;
    private String buildKey = "bin.includes";

    public BuildEditor(IProject project) {
        this(project, null);
    }

    public BuildEditor(IProject project, String buildKey) {
        super(project);
        this.buildFile = project.getFile("build.properties");
        if (buildKey != null) {
            this.buildKey = buildKey;
        }
    }

    @Override
    public void init() {
        this.buildConfig = new Properties();
        if (this.buildFile.exists()) {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (InputStream input = this.buildFile.getContents();){
                    this.buildConfig.load(input);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                Activator.log.log(e.getStatus());
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public void addToBuild(String path) {
        if (this.exists()) {
            String currentValue = this.buildConfig.getProperty(this.buildKey);
            if (Arrays.asList(this.getElementsInBuild()).contains(path)) {
                return;
            }
            this.touch();
            if (currentValue == null || currentValue.trim().equals("")) {
                this.buildConfig.setProperty(this.buildKey, path);
            } else {
                this.buildConfig.setProperty(this.buildKey, currentValue + "," + path);
            }
        }
    }

    @Override
    public void removeFromBuild(String path) {
        if (this.isRegisteredSourceFolder(path)) {
            this.touch();
            List<String> allFiles = Arrays.asList(this.getElementsInBuild());
            this.buildConfig.setProperty(this.buildKey, "");
            for (String filePath : allFiles) {
                if (filePath.equals(path)) continue;
                this.addToBuild(filePath);
            }
        }
    }

    @Override
    protected void doSave() {
        if (this.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (PlatformResourceURIHandlerImpl.PlatformResourceOutputStream output = new PlatformResourceURIHandlerImpl.PlatformResourceOutputStream(this.buildFile, false, true, null);){
                    this.buildConfig.store((OutputStream)output, "");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    @Override
    public void registerSourceFolder(String path) {
        if (this.exists() && !this.isRegisteredSourceFolder(path)) {
            this.touch();
            String currentValue = this.buildConfig.getProperty("source..");
            if (currentValue == null || currentValue.trim().equals("")) {
                this.buildConfig.setProperty("source..", path);
            } else {
                this.buildConfig.setProperty("source..", currentValue + "," + path);
            }
        }
    }

    @Override
    public boolean isRegisteredSourceFolder(String path) {
        return Arrays.asList(this.getSourceFolders()).contains(path);
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        if (!this.buildFile.exists()) {
            files.add("build.properties");
        }
        return files;
    }

    @Override
    public String[] getSourceFolders() {
        if (this.exists()) {
            String currentValue = this.buildConfig.getProperty("source..", "").replaceAll("\t|\r|\n", "").trim();
            String[] values = currentValue.split(",");
            return values;
        }
        return new String[0];
    }

    @Override
    public boolean exists() {
        return super.exists() && this.buildFile.exists();
    }

    @Override
    public void createFiles(Set<String> files) {
        if (files.contains("build.properties") && !this.buildFile.exists()) {
            try {
                this.buildFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
                this.init();
            }
            catch (CoreException e) {
                Activator.log.log(e.getStatus());
            }
        }
    }

    @Override
    public String[] getElementsInBuild() {
        String value = this.buildConfig.getProperty(this.buildKey);
        return this.splitValues(value);
    }

    private String[] splitValues(String value) {
        if (value == null) {
            return new String[0];
        }
        return value.replace("\t|\r|\n", "").split(",");
    }

    @Override
    public void registerBinFolder(String binFolder) {
        if (this.isRegisteredBinFolder(binFolder)) {
            return;
        }
        this.touch();
        Object value = this.buildConfig.getProperty("bin..", "");
        value = ((String)value).trim().equals("") ? binFolder : (String)value + "," + binFolder;
        this.buildConfig.setProperty("bin..", (String)value);
    }

    @Override
    public boolean isRegisteredBinFolder(String binFolder) {
        List<String> folders = Arrays.asList(this.splitValues(this.buildConfig.getProperty("bin..", "")));
        return folders.contains(binFolder);
    }

    @Override
    public String[] getSourceIncludes() {
        String value = this.buildConfig.getProperty("src.includes");
        return this.splitValues(value);
    }
}

