/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.LabelHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetLocationCommand;

public class MoveableNonResizableLabelEditPolicy
extends NonResizableEditPolicyEx {
    private Polyline tether = null;

    protected List<? extends Handle> createSelectionHandles() {
        MoveHandle mh = new MoveHandle(this.getHost());
        mh.setBorder(null);
        mh.setDragTracker(this.createSelectionHandleDragTracker());
        return Collections.singletonList(mh);
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        if (this.tether != null) {
            this.removeFeedback((IFigure)this.tether);
        }
        this.tether = null;
    }

    protected IFigure createDragSourceFeedbackFigure() {
        IFigure feedback = super.createDragSourceFeedbackFigure();
        this.tether = new Polyline();
        this.tether.setLineStyle(4);
        this.tether.setForegroundColor(this.getHost().getFigure().getForegroundColor());
        this.addFeedback((IFigure)this.tether);
        return feedback;
    }

    private Point getReferencePoint() {
        if (this.getHost().getParent() instanceof AbstractConnectionEditPart) {
            PointList ptList = ((Connection)((ConnectionEditPart)this.getHost().getParent()).getFigure()).getPoints();
            Point refPoint = PointListUtilities.calculatePointRelativeToLine((PointList)ptList, (int)0, (int)50, (boolean)true);
            return refPoint;
        }
        if (this.getHost().getParent() instanceof GraphicalEditPart) {
            return ((AbstractGraphicalEditPart)this.getHost().getParent()).getFigure().getBounds().getCenter();
        }
        return null;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.showChangeBoundsFeedback(request);
        IFigure p = this.getDragSourceFeedbackFigure();
        Rectangle r = p.getBounds();
        Point refPoint = this.getReferencePoint();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        p.translateToRelative((Translatable)rect);
        p.setBounds((Rectangle)rect);
        Rectangle centerMain = null;
        if (((IGraphicalEditPart)this.getHost().getParent()).getFigure() instanceof Connection) {
            centerMain = new Rectangle(refPoint.x, refPoint.y, 0, 0);
            this.getHostFigure().translateToAbsolute((Translatable)centerMain);
            p.translateToRelative((Translatable)centerMain);
        } else {
            centerMain = ((IGraphicalEditPart)this.getHost().getParent()).getFigure().getBounds().getCopy();
            centerMain.translate(centerMain.width / 2, centerMain.height / 2);
            this.getHostFigure().translateToAbsolute((Translatable)centerMain);
            p.translateToRelative((Translatable)centerMain);
        }
        PrecisionRectangle ref = new PrecisionRectangle(centerMain);
        Point midTop = new Point(r.x + r.width / 2, r.y);
        Point midBottom = new Point(r.x + r.width / 2, r.y + r.height);
        Point midLeft = new Point(r.x, r.y + r.height / 2);
        Point midRight = new Point(r.x + r.width, r.y + r.height / 2);
        Point startPoint = midTop;
        int x = r.x + r.width / 2 - refPoint.x;
        int y = r.y + r.height / 2 - refPoint.y;
        startPoint = y > 0 && y > x && y > -x ? midTop : (y < 0 && y < x && y < -x ? midBottom : (x < 0 && y > x && y < -x ? midRight : midLeft));
        this.tether.setStart(startPoint);
        this.tether.setEnd(ref.getLocation());
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        GraphicalEditPart editPart = (GraphicalEditPart)this.getHost();
        Point refPoint = this.getReferencePoint();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        this.getHostFigure().translateToRelative((Translatable)rect);
        Point normalPoint = LabelHelper.offsetFromRelativeCoordinate((IFigure)this.getHostFigure(), (Rectangle)rect, (Point)refPoint);
        SetLocationCommand moveCommand = new SetLocationCommand(editPart.getEditingDomain(), DiagramUIMessages.MoveLabelCommand_Label_Location, (IAdaptable)new EObjectAdapter((EObject)((View)editPart.getModel())), normalPoint);
        return new ICommandProxy((ICommand)moveCommand);
    }

    protected DragTracker createSelectionHandleDragTracker() {
        return new DragEditPartsTrackerEx((EditPart)this.getHost()){

            protected boolean isMove() {
                return true;
            }
        };
    }
}

