/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextComponentMatcherEditor<E>
extends TextMatcherEditor<E> {
    private Document document;
    private final JTextComponent textComponent;
    private boolean live;
    private final FilterHandler filterHandler = new FilterHandler();

    public TextComponentMatcherEditor(JTextComponent textComponent, TextFilterator<? super E> textFilterator) {
        this(textComponent, textFilterator, true);
    }

    public TextComponentMatcherEditor(JTextComponent textComponent, TextFilterator<? super E> textFilterator, boolean live) {
        this(textComponent, textComponent.getDocument(), textFilterator, live);
    }

    public TextComponentMatcherEditor(Document document, TextFilterator<? super E> textFilterator) {
        this(null, document, textFilterator, true);
    }

    private TextComponentMatcherEditor(JTextComponent textComponent, Document document, TextFilterator<? super E> textFilterator, boolean live) {
        super(textFilterator);
        this.textComponent = textComponent;
        this.document = document;
        this.live = live;
        this.registerListeners(live);
        this.refilter();
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        if (live == this.live) {
            return;
        }
        this.deregisterListeners(this.live);
        this.live = live;
        this.registerListeners(this.live);
    }

    private void registerListeners(boolean live) {
        if (live) {
            this.document.addDocumentListener(this.filterHandler);
        } else {
            if (this.textComponent == null) {
                throw new IllegalArgumentException("Non-live filtering supported only for JTextField (document provided)");
            }
            if (!(this.textComponent instanceof JTextField)) {
                throw new IllegalArgumentException("Non-live filtering supported only for JTextField (argument class " + this.textComponent.getClass().getName() + ")");
            }
            JTextField textField = (JTextField)this.textComponent;
            textField.addActionListener(this.filterHandler);
        }
        if (this.textComponent != null) {
            this.textComponent.addPropertyChangeListener(this.filterHandler);
        }
    }

    private void deregisterListeners(boolean live) {
        if (live) {
            this.document.removeDocumentListener(this.filterHandler);
        } else {
            JTextField textField = (JTextField)this.textComponent;
            textField.removeActionListener(this.filterHandler);
        }
        if (this.textComponent != null) {
            this.textComponent.removePropertyChangeListener(this.filterHandler);
        }
    }

    public void dispose() {
        this.deregisterListeners(this.live);
    }

    private void refilter() {
        try {
            String[] filters;
            int mode = this.getMode();
            String text = this.document.getText(0, this.document.getLength());
            if (mode == 0) {
                filters = text.split("[ \t]");
            } else if (mode == 1 || mode == 2 || mode == 3) {
                filters = new String[]{text};
            } else {
                throw new IllegalStateException("Unknown mode: " + mode);
            }
            this.setFilterText(filters);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    private class FilterHandler
    implements DocumentListener,
    ActionListener,
    PropertyChangeListener {
        private FilterHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextComponentMatcherEditor.this.refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextComponentMatcherEditor.this.refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TextComponentMatcherEditor.this.refilter();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentMatcherEditor.this.refilter();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("document" == evt.getPropertyName()) {
                TextComponentMatcherEditor.this.deregisterListeners(TextComponentMatcherEditor.this.live);
                TextComponentMatcherEditor.this.document = TextComponentMatcherEditor.this.textComponent.getDocument();
                TextComponentMatcherEditor.this.registerListeners(TextComponentMatcherEditor.this.live);
                TextComponentMatcherEditor.this.refilter();
            }
        }
    }
}

