/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.IPapyrusWrappingLabel;
import org.eclipse.swt.graphics.Image;

public class PapyrusWrappingLabel
extends WrappingLabel
implements IPapyrusWrappingLabel {
    public static final int AUTO_SIZE = -1;
    private int labelWidth = -1;
    private int labelHeight = -1;

    public PapyrusWrappingLabel(Image image) {
        super(image);
    }

    public PapyrusWrappingLabel(String text) {
        super(text);
    }

    public PapyrusWrappingLabel() {
    }

    public PapyrusWrappingLabel(String text, Image image) {
        super(text, image);
    }

    public boolean containsPoint(int x, int y) {
        if (this.isVisible()) {
            return super.containsPoint(x, y);
        }
        return false;
    }

    @Override
    public void setMarginLabel(int xMargin, int yMargin) {
        this.setMarginLabel(xMargin, yMargin, xMargin, yMargin);
    }

    @Override
    public void setMarginLabel(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
        MarginBorder mb = new MarginBorder(topMargin, leftMargin, bottomMargin, rightMargin);
        this.setBorder((Border)mb);
        this.repaint();
        this.revalidate();
    }

    public void setLabelHeight(int labelHeight) {
        this.labelHeight = labelHeight;
    }

    public void setLabelWidth(int labelWidth) {
        this.labelWidth = labelWidth;
    }

    public void setLabelSize(int width, int height) {
        this.setLabelWidth(width);
        this.setLabelHeight(height);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension prefSize = super.getPreferredSize(wHint, hHint);
        if (this.labelHeight > 0) {
            prefSize.height = this.labelHeight;
        }
        if (this.labelWidth > 0) {
            prefSize.width = this.labelWidth;
        }
        return prefSize;
    }
}

