/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.representation.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.representation.AssistantRule;
import org.eclipse.papyrus.infra.gmfdiag.representation.ChildRule;
import org.eclipse.papyrus.infra.gmfdiag.representation.PaletteRule;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.gmfdiag.representation.PathElement;
import org.eclipse.papyrus.infra.gmfdiag.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.gmfdiag.representation.impl.RepresentationPlugin;

public class RepresentationValidator
extends EObjectValidator {
    public static final RepresentationValidator INSTANCE = new RepresentationValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.infra.gmfdiag.representation";
    public static final int PAPYRUS_DIAGRAM__CEATION_COMMAND_CLASS_EXISTS = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;

    protected EPackage getEPackage() {
        return RepresentationPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatePapyrusDiagram((PapyrusDiagram)value, diagnostics, context);
            }
            case 1: {
                return this.validateChildRule((ChildRule)value, diagnostics, context);
            }
            case 2: {
                return this.validatePaletteRule((PaletteRule)value, diagnostics, context);
            }
            case 3: {
                return this.validatePathElement((PathElement)value, diagnostics, context);
            }
            case 4: {
                return this.validateAssistantRule((AssistantRule)value, diagnostics, context);
            }
            case 5: {
                return this.validateElementType((IElementType)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePapyrusDiagram(PapyrusDiagram papyrusDiagram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)papyrusDiagram, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)papyrusDiagram, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)papyrusDiagram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)papyrusDiagram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)papyrusDiagram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)papyrusDiagram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)papyrusDiagram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)papyrusDiagram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)papyrusDiagram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validatePapyrusDiagram_ceationCommandClassExists(papyrusDiagram, diagnostics, context);
        }
        return result;
    }

    public boolean validatePapyrusDiagram_ceationCommandClassExists(PapyrusDiagram papyrusDiagram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return papyrusDiagram.ceationCommandClassExists(diagnostics, context);
    }

    public boolean validateChildRule(ChildRule childRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)childRule, diagnostics, context);
    }

    public boolean validatePaletteRule(PaletteRule paletteRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)paletteRule, diagnostics, context);
    }

    public boolean validatePathElement(PathElement pathElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(pathElement, diagnostics, context);
    }

    public boolean validateAssistantRule(AssistantRule assistantRule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)assistantRule, diagnostics, context);
    }

    public boolean validateElementType(IElementType elementType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return RepresentationPlugin.INSTANCE;
    }
}

