/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors.richtext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditorConfiguration;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class GenericRichTextEditor
extends RichTextEditor {
    protected static URL cssURL;
    private boolean tagsEnabled;
    private static final String CKEDITOR_ALLOWED_CONTENT = "CKEDITOR.config.allowedContent=true;";
    private static final String CKEDITOR_CONTENTS_CSS = "CKEDITOR.config.contentsCss=";
    private static final String FILE_SCHEME_FOR_BUNDLES = "file:/";
    private static final String FILE_SCHEME_FOR_JAVASCRIPT = "file:///";
    private static final String PAPYRUS_CSS_FILENAME = "PapyrusContents.css";
    private EObject editedObject;
    private EStructuralFeature editedFeature;

    static {
        GenericRichTextEditor.locateCSSURL();
    }

    public GenericRichTextEditor(Composite parent, GenericRichTextEditorConfiguration editorConfig, int style) {
        super(parent, (RichTextEditorConfiguration)editorConfig, style | 0x1000000);
        editorConfig.setBrowser(this.getEditorConfiguration().getBrowser());
        editorConfig.setRichTextEditor(this);
    }

    public GenericRichTextEditor(Composite parent, GenericRichTextEditorConfiguration editorConfig) {
        this(parent, editorConfig, 0x1000000);
    }

    public GenericRichTextEditor(Composite parent) {
        this(parent, 0x1000000);
    }

    public GenericRichTextEditor(Composite parent, int style) {
        this(parent, new GenericRichTextEditorConfiguration(), style);
    }

    public boolean isTagsEnabled() {
        return this.tagsEnabled;
    }

    public boolean enableTags() {
        if (!this.tagsEnabled) {
            try {
                this.executeJavascript("CKEDITOR.config.contentsCss=CKEDITOR.getUrl(\"" + cssURL.toString().replace(FILE_SCHEME_FOR_BUNDLES, FILE_SCHEME_FOR_JAVASCRIPT) + "\");");
                this.tagsEnabled = this.executeJavascript(CKEDITOR_ALLOWED_CONTENT);
            }
            catch (Exception e) {
                this.tagsEnabled = false;
            }
        }
        return this.tagsEnabled;
    }

    public void configureEdition(EObject editedEObject, EStructuralFeature editedFeature) {
        this.editedObject = editedEObject;
        this.editedFeature = editedFeature;
    }

    public EObject getEditedObject() {
        return this.editedObject;
    }

    public EStructuralFeature getEditedFeature() {
        return this.editedFeature;
    }

    private static void locateCSSURL() {
        cssURL = GenericRichTextEditor.class.getResource("resources/PapyrusContents.css");
        Bundle bundle = FrameworkUtil.getBundle(GenericRichTextEditor.class);
        if (bundle != null) {
            try {
                cssURL = FileLocator.toFileURL((URL)cssURL);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        } else if (cssURL.toString().startsWith("jar")) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    URL jarURL = GenericRichTextEditor.class.getProtectionDomain().getCodeSource().getLocation();
                    File jarFileReference = null;
                    if (jarURL.getProtocol().equals("file")) {
                        try {
                            String decodedPath = URLDecoder.decode(jarURL.getPath(), "UTF-8");
                            jarFileReference = new File(decodedPath);
                        }
                        catch (UnsupportedEncodingException e) {
                            Activator.log.error((Throwable)e);
                        }
                    } else {
                        try {
                            final Path jar = Files.createTempFile("richtext", ".jar", new FileAttribute[0]);
                            Files.copy(jarURL.openStream(), jar, StandardCopyOption.REPLACE_EXISTING);
                            jarFileReference = jar.toFile();
                            Runtime.getRuntime().addShutdownHook(new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        Files.delete(jar);
                                    }
                                    catch (IOException e) {
                                        Activator.log.error((Throwable)e);
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                    if (jarFileReference == null) return;
                    try {
                        Throwable e = null;
                        Object var4_8 = null;
                        try (JarFile jarFile = new JarFile(jarFileReference);){
                            Path tempDir;
                            String unpackDirectory = System.getProperty("org.eclipse.nebula.widgets.richtext.jar.unpackdir");
                            Path path = tempDir = unpackDirectory == null ? Files.createTempDirectory("richtext", new FileAttribute[0]) : Files.createDirectories(Paths.get(unpackDirectory, new String[0]), new FileAttribute[0]);
                            if (unpackDirectory == null) {
                                Runtime.getRuntime().addShutdownHook(new Thread(){

                                    @Override
                                    public void run() {
                                        try {
                                            Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                                @Override
                                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                                    Files.delete(file);
                                                    return FileVisitResult.CONTINUE;
                                                }

                                                @Override
                                                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                                    Files.delete(dir);
                                                    return FileVisitResult.CONTINUE;
                                                }
                                            });
                                        }
                                        catch (IOException e) {
                                            Activator.log.error((Throwable)e);
                                        }
                                    }
                                });
                            }
                            Enumeration<JarEntry> entries = jarFile.entries();
                            while (true) {
                                File file;
                                String name;
                                block35: {
                                    if (!entries.hasMoreElements()) {
                                        return;
                                    }
                                    JarEntry entry = entries.nextElement();
                                    name = entry.getName();
                                    if (!name.startsWith("org/eclipse/papyrus/infra/widgets/editors/richtext/resources")) continue;
                                    file = new File(String.valueOf(tempDir.toAbsolutePath()) + File.separator + name);
                                    if (!file.exists()) {
                                        if (entry.isDirectory()) {
                                            file.mkdirs();
                                        } else {
                                            Throwable throwable = null;
                                            Object var13_19 = null;
                                            try {
                                                InputStream is = jarFile.getInputStream(entry);
                                                try {
                                                    try (FileOutputStream os = new FileOutputStream(file);){
                                                        while (is.available() > 0) {
                                                            ((OutputStream)os).write(is.read());
                                                        }
                                                    }
                                                    if (is == null) break block35;
                                                }
                                                catch (Throwable throwable2) {
                                                    if (throwable == null) {
                                                        throwable = throwable2;
                                                    } else if (throwable != throwable2) {
                                                        throwable.addSuppressed(throwable2);
                                                    }
                                                    if (is == null) throw throwable;
                                                    is.close();
                                                    throw throwable;
                                                }
                                                is.close();
                                            }
                                            catch (Throwable throwable3) {
                                                if (throwable == null) {
                                                    throwable = throwable3;
                                                    throw throwable;
                                                }
                                                if (throwable == throwable3) throw throwable;
                                                throwable.addSuppressed(throwable3);
                                                throw throwable;
                                            }
                                        }
                                    }
                                }
                                if (!name.endsWith(GenericRichTextEditor.PAPYRUS_CSS_FILENAME)) continue;
                                cssURL = file.toURI().toURL();
                            }
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                                throw e;
                            }
                            if (e == throwable) throw e;
                            e.addSuppressed(throwable);
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            });
        }
    }
}

