/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.commands;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.command.InteractiveCommandWrapper;
import org.eclipse.swt.widgets.Display;

public class RenameElementCommand
extends InteractiveCommandWrapper {
    private TransactionalEditingDomain editingDomain = null;
    private EObject element = null;
    private String currentElementName = null;
    private EStructuralFeature nameStructuralFeature = null;
    private String dialogTitle = null;
    private String dialogMessage = null;

    public RenameElementCommand(TransactionalEditingDomain editingDomain, String commandLabel, EObject element, String currentElementName, EStructuralFeature nameStructuralFeature, String dialogTitle, String dialogMessage) {
        super(commandLabel);
        this.editingDomain = editingDomain;
        this.element = element;
        this.currentElementName = currentElementName;
        this.nameStructuralFeature = nameStructuralFeature;
        this.dialogTitle = dialogTitle;
        this.dialogMessage = dialogMessage;
    }

    protected Command createCommand() {
        SetRequest request;
        IElementEditService edit;
        String newName;
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), this.dialogTitle, this.dialogMessage, this.currentElementName, null);
        if (this.editingDomain != null && this.element != null && this.nameStructuralFeature != null && dialog.open() == 0 && (newName = dialog.getValue()) != null && !newName.isEmpty() && !newName.equals(this.currentElementName) && (edit = ElementEditServiceUtils.getCommandProvider((EObject)this.element)).canEdit((IEditCommandRequest)(request = new SetRequest(this.editingDomain, this.element, this.nameStructuralFeature, (Object)newName)))) {
            result = (Command)ICommandWrapper.wrap((Object)edit.getEditCommand((IEditCommandRequest)request), Command.class);
        }
        return result;
    }
}

