/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editor.reload;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.editor.reload.IDisposableReloadContext;
import org.eclipse.papyrus.infra.ui.editor.reload.IEditorReloadListener;
import org.eclipse.papyrus.infra.ui.editor.reload.IInternalEMFSelectionContext;

public class EditorReloadEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int ABOUT_TO_RELOAD = 1;
    public static final int RELOADED = 2;
    private int type;
    private transient Map<IEditorReloadListener, Object> context;
    private transient IEditorReloadListener currentListener;

    public EditorReloadEvent(IMultiDiagramEditor editor) {
        super(editor);
    }

    public final IMultiDiagramEditor getEditor() {
        return (IMultiDiagramEditor)this.getSource();
    }

    public final int getEventType() {
        return this.type;
    }

    public Object putContext(Object object) {
        this.checkContext(1);
        IInternalEMFSelectionContext emfContext = (IInternalEMFSelectionContext)AdapterUtils.adapt((Object)object, IInternalEMFSelectionContext.class, null);
        if (emfContext != null) {
            this.initContext(emfContext);
        }
        return this.context.put(this.currentListener, object);
    }

    public Object getContext() {
        this.checkContext(2);
        return this.context.get(this.currentListener);
    }

    private void initContext(IInternalEMFSelectionContext context) {
        Supplier<ResourceSet> resourceSetSupplier = new Supplier<ResourceSet>(){

            public ResourceSet get() {
                try {
                    return (ResourceSet)EditorReloadEvent.this.getEditor().getServicesRegistry().getService(ModelSet.class);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                    throw new IllegalStateException("Invalid service registry in editor");
                }
            }
        };
        context.setResourceSetSupplier((Supplier<? extends ResourceSet>)resourceSetSupplier);
    }

    protected final void checkContext(int phase) {
        if (this.currentListener == null) {
            throw new IllegalStateException("Not in an IEditorReloadListener call-back");
        }
        if (phase != this.type) {
            throw new IllegalStateException(String.format("Not in '%s' listener call-back", phase == 1 ? "editorAboutToReload" : "editorReloaded"));
        }
    }

    public final void dispatchEditorAboutToReload(Iterable<? extends IEditorReloadListener> listeners) {
        this.context = Maps.newHashMap();
        this.type = 1;
        for (IEditorReloadListener this.currentListener : listeners) {
            try {
                try {
                    this.currentListener.editorAboutToReload(this);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in editor reload listener.", (Throwable)e);
                    this.currentListener = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.currentListener = null;
                throw throwable;
            }
            this.currentListener = null;
        }
    }

    public final void dispatchEditorReloaded(Iterable<? extends IEditorReloadListener> listeners) {
        this.type = 2;
        for (IEditorReloadListener this.currentListener : listeners) {
            try {
                try {
                    this.currentListener.editorReloaded(this);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in editor reload listener.", (Throwable)e);
                    this.currentListener = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.currentListener = null;
                throw throwable;
            }
            this.currentListener = null;
        }
    }

    public void dispose() {
        if (this.context != null) {
            Error error = null;
            try {
                for (IDisposableReloadContext next : Iterables.filter(this.context.values(), IDisposableReloadContext.class)) {
                    try {
                        next.dispose();
                    }
                    catch (Exception e) {
                        Activator.log.error("Uncaught exception in editor reload context disposal.", (Throwable)e);
                    }
                    catch (Error e) {
                        if (error == null) {
                            error = e;
                        }
                        Activator.log.error("Uncaught exception in editor reload context disposal.", (Throwable)e);
                    }
                }
            }
            finally {
                this.context = null;
            }
            if (error != null) {
                throw error;
            }
        }
    }
}

