/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.utils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Lifeline;

public class RequestParameterUtils {
    @Deprecated
    private static final String COVERED_REQUEST_PARAMETER = "Element Covers this one";

    public static View getSourceView(IEditCommandRequest req) {
        return (View)req.getParameter("SOURCE_GRAPHICAL_VIEW");
    }

    public static View getTargetView(IEditCommandRequest req) {
        return (View)req.getParameter("TARGET_GRAPHICAL_VIEW");
    }

    public static Edge getReconnectedEdge(IEditCommandRequest req) {
        return (Edge)req.getParameter("graphical_edge");
    }

    public static View getReconnectedEndView(IEditCommandRequest req) {
        return (View)req.getParameter("RECONNECT_END_VIEW");
    }

    public static List<EObject> getDependentsToKeep(IEditCommandRequest req) {
        return RequestParameterUtils.getDependentsToKeep(req, false);
    }

    public static List<EObject> getDependentsToKeep(IEditCommandRequest req, boolean create) {
        ArrayList result = (ArrayList)req.getParameter("DEPENDENTS_TO_KEEP");
        if (result == null && create) {
            result = new ArrayList();
            req.setParameter("DEPENDENTS_TO_KEEP", result);
        }
        return result;
    }

    public static List<EObject> getAssociationRefactoredElements(IEditCommandRequest req) {
        return (List)req.getParameter("ASSOCIATION_REFACTORED_ELEMENTS");
    }

    public static void addAssociationRefactoredElement(IEditCommandRequest req, EObject eObject) {
        ArrayList<EObject> refactoredElements = RequestParameterUtils.getAssociationRefactoredElements(req) != null ? RequestParameterUtils.getAssociationRefactoredElements(req) : new ArrayList<EObject>();
        refactoredElements.add(eObject);
        req.setParameter("ASSOCIATION_REFACTORED_ELEMENTS", refactoredElements);
    }

    public static Iterable<Lifeline> getCoveredLifelines(IEditCommandRequest request) {
        Set<Lifeline> result = Collections.emptySet();
        Object parameterValue = request.getParameter("PAPYRUS_SEQD_COVERED_LIFELINES");
        if (parameterValue instanceof Iterable) {
            result = Iterables.filter((Iterable)((Iterable)parameterValue), Lifeline.class);
        } else if (request.getParameter(COVERED_REQUEST_PARAMETER) instanceof Lifeline) {
            result = Collections.singleton((Lifeline)request.getParameter(COVERED_REQUEST_PARAMETER));
        }
        return result;
    }

    public static void setCoveredLifelines(IEditCommandRequest request, Iterable<Lifeline> coveredLifelines) {
        request.setParameter("PAPYRUS_SEQD_COVERED_LIFELINES", (Object)ImmutableSet.copyOf(coveredLifelines));
    }
}

