/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class ConfigureMessageEventCommand
extends ConfigureElementCommand {
    private List<MessageOccurrenceSpecification> createdMessageEnds;
    private Map<Lifeline, List<MessageOccurrenceSpecification>> coveredLifelines;
    private Message oldMessage;
    private ExecutionOccurrenceSpecification oldToReplacebyMessageSent;
    private ExecutionOccurrenceSpecification oldToReplacebyMessageReceive;
    private List<ICommand> destroyedElementsCommands;
    private ConfigureRequest request;

    public ConfigureMessageEventCommand(ConfigureRequest request) {
        super(request);
        this.request = request;
    }

    public MessageOccurrenceSpecification createMessageEnd(Message message, Lifeline lifeline, MessageEnd previous) {
        List<MessageOccurrenceSpecification> newCoveredBy;
        MessageOccurrenceSpecification messageOccurrenceSpecification = UMLFactory.eINSTANCE.createMessageOccurrenceSpecification();
        if (previous == null) {
            messageOccurrenceSpecification.setCovered(lifeline);
        } else {
            int index = lifeline.getCoveredBys().indexOf((Object)previous) + 1;
            lifeline.getCoveredBys().add(index, (Object)messageOccurrenceSpecification);
        }
        if (this.coveredLifelines == null) {
            this.coveredLifelines = new HashMap<Lifeline, List<MessageOccurrenceSpecification>>();
        }
        if ((newCoveredBy = this.coveredLifelines.get(lifeline)) == null) {
            newCoveredBy = new ArrayList<MessageOccurrenceSpecification>();
            this.coveredLifelines.put(lifeline, newCoveredBy);
        }
        newCoveredBy.add(messageOccurrenceSpecification);
        messageOccurrenceSpecification.setMessage(message);
        ((Interaction)message.getOwner()).getFragments().add((Object)messageOccurrenceSpecification);
        return messageOccurrenceSpecification;
    }

    public DestructionOccurrenceSpecification createDestroyMessageEnd(Message message, Lifeline lifeline) {
        DestructionOccurrenceSpecification messageOccurrenceSpecification = UMLFactory.eINSTANCE.createDestructionOccurrenceSpecification();
        messageOccurrenceSpecification.setCovered(lifeline);
        messageOccurrenceSpecification.setMessage(message);
        ((Interaction)message.getOwner()).getFragments().add((Object)messageOccurrenceSpecification);
        return messageOccurrenceSpecification;
    }

    protected Element getSource(ConfigureRequest req) {
        Element result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof Element) {
            result = (Element)paramObject;
        }
        return result;
    }

    protected Element getTarget(ConfigureRequest req) {
        Element result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof Element) {
            result = (Element)paramObject;
        }
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ICommand destroyCommand;
        DestroyElementRequest destroyRequest;
        IElementEditService provider;
        Message message = (Message)this.request.getElementToConfigure();
        this.oldMessage = (Message)EcoreUtil.copy((EObject)message);
        Element source = this.getSource(this.request);
        Element target = this.getTarget(this.request);
        MessageEnd previousSentEvent = (MessageEnd)this.request.getParameters().get("previous event");
        MessageEnd previousReceiveEvent = (MessageEnd)this.request.getParameters().get("second previous event");
        ExecutionOccurrenceSpecification toReplacebyMessageSent = (ExecutionOccurrenceSpecification)this.request.getParameters().get("MESSAGE_SENTEVENT_REPLACE_EXECUTIONEVENT");
        ExecutionOccurrenceSpecification toReplacebyMessageReceive = (ExecutionOccurrenceSpecification)this.request.getParameters().get("MESSAGE_RECEIVEEVENT_REPLACE_EXECUTIONEVENT");
        this.oldToReplacebyMessageSent = toReplacebyMessageSent;
        this.oldToReplacebyMessageReceive = toReplacebyMessageReceive;
        this.createdMessageEnds = new ArrayList<MessageOccurrenceSpecification>(2);
        IElementType elementType = this.request.getTypeToConfigure();
        if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_ASYNCH_CALL)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_ASYNCH_SIGNAL)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_CREATE_MESSAGE)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_DELETE_MESSAGE)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            this.createdMessageEnds.add((MessageOccurrenceSpecification)this.createDestroyReceiveEvent(message, target));
            message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_REPLY)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.REPLY_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.COMPLETE_SYNCH_CALL)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.SYNCH_CALL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_ASYNCH_CALL)) {
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_ASYNCH_SIGNAL)) {
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_CREATE_MESSAGE)) {
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_DELETE_MESSAGE)) {
            this.createdMessageEnds.add((MessageOccurrenceSpecification)this.createDestroyReceiveEvent(message, target));
            message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.FOUND_REPLY)) {
            this.createdMessageEnds.add(this.createReceiveEvent(message, target, previousReceiveEvent));
            message.setMessageSort(MessageSort.REPLY_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_ASYNCH_CALL)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            message.setMessageSort(MessageSort.ASYNCH_CALL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_ASYNCH_SIGNAL)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            message.setMessageSort(MessageSort.ASYNCH_SIGNAL_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_CREATE_MESSAGE)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            message.setMessageSort(MessageSort.CREATE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_DELETE_MESSAGE)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            message.setMessageSort(MessageSort.DELETE_MESSAGE_LITERAL);
        } else if (ElementUtil.isTypeOf(elementType, (IElementType)UMLElementTypes.LOST_REPLY)) {
            this.createdMessageEnds.add(this.createSendEvent(message, source, previousSentEvent));
            message.setMessageSort(MessageSort.REPLY_LITERAL);
        }
        if (toReplacebyMessageSent != null) {
            if (toReplacebyMessageSent.getExecution() != null) {
                if (toReplacebyMessageSent.getExecution().getStart().equals(toReplacebyMessageSent)) {
                    toReplacebyMessageSent.getExecution().setStart((OccurrenceSpecification)message.getSendEvent());
                } else {
                    toReplacebyMessageSent.getExecution().setFinish((OccurrenceSpecification)message.getSendEvent());
                }
            }
            if (toReplacebyMessageSent.getOwner() != null && (provider = ElementEditServiceUtils.getCommandProvider((EObject)toReplacebyMessageSent)) != null) {
                destroyRequest = new DestroyElementRequest((EObject)toReplacebyMessageSent, false);
                destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                destroyCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (this.destroyedElementsCommands == null) {
                    this.destroyedElementsCommands = new ArrayList<ICommand>();
                }
                this.destroyedElementsCommands.add(destroyCommand);
            }
        }
        if (toReplacebyMessageReceive != null) {
            if (toReplacebyMessageReceive.getExecution() != null) {
                if (toReplacebyMessageReceive.getExecution().getStart().equals(toReplacebyMessageReceive)) {
                    toReplacebyMessageReceive.getExecution().setStart((OccurrenceSpecification)message.getReceiveEvent());
                } else {
                    toReplacebyMessageReceive.getExecution().setFinish((OccurrenceSpecification)message.getReceiveEvent());
                }
            }
            if (toReplacebyMessageReceive.getOwner() != null && (provider = ElementEditServiceUtils.getCommandProvider((EObject)toReplacebyMessageReceive)) != null) {
                destroyRequest = new DestroyElementRequest((EObject)toReplacebyMessageReceive, false);
                destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
                destroyCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (this.destroyedElementsCommands == null) {
                    this.destroyedElementsCommands = new ArrayList<ICommand>();
                }
                this.destroyedElementsCommands.add(destroyCommand);
            }
        }
        return CommandResult.newOKCommandResult((Object)message);
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Message message = (Message)this.request.getElementToConfigure();
        ExecutionOccurrenceSpecification toReplacebyMessageSent = (ExecutionOccurrenceSpecification)this.request.getParameters().get("MESSAGE_SENTEVENT_REPLACE_EXECUTIONEVENT");
        ExecutionOccurrenceSpecification toReplacebyMessageReceive = (ExecutionOccurrenceSpecification)this.request.getParameters().get("MESSAGE_RECEIVEEVENT_REPLACE_EXECUTIONEVENT");
        message.setMessageSort(this.oldMessage.getMessageSort());
        message.setSendEvent(this.oldMessage.getSendEvent());
        message.setReceiveEvent(this.oldMessage.getReceiveEvent());
        if (this.createdMessageEnds != null && !this.createdMessageEnds.isEmpty()) {
            for (MessageEnd messageEnd : this.createdMessageEnds) {
                if (messageEnd == null) continue;
                EObject container = messageEnd.eContainer();
                if (container instanceof Interaction) {
                    ((Interaction)container).getFragments().remove((Object)messageEnd);
                    continue;
                }
                if (!(container instanceof InteractionOperand)) continue;
                ((InteractionOperand)container).getFragments().remove((Object)messageEnd);
            }
        }
        if (this.coveredLifelines != null && !this.coveredLifelines.isEmpty()) {
            for (Map.Entry entry : this.coveredLifelines.entrySet()) {
                for (MessageOccurrenceSpecification addedCoveredBy : (List)entry.getValue()) {
                    ((Lifeline)entry.getKey()).getCoveredBys().remove((Object)addedCoveredBy);
                }
            }
        }
        if (this.oldToReplacebyMessageSent != null && this.oldToReplacebyMessageSent.getExecution() != null) {
            if (this.oldToReplacebyMessageSent.getExecution().getStart().equals(this.oldToReplacebyMessageSent)) {
                toReplacebyMessageSent.getExecution().setStart(this.oldToReplacebyMessageSent.getExecution().getStart());
            } else {
                toReplacebyMessageSent.getExecution().setFinish(this.oldToReplacebyMessageSent.getExecution().getFinish());
            }
        }
        if (this.oldToReplacebyMessageReceive != null && this.oldToReplacebyMessageReceive.getExecution() != null) {
            if (this.oldToReplacebyMessageReceive.getExecution().getStart().equals(this.oldToReplacebyMessageReceive)) {
                toReplacebyMessageReceive.getExecution().setStart(this.oldToReplacebyMessageReceive.getExecution().getStart());
            } else {
                toReplacebyMessageReceive.getExecution().setFinish(this.oldToReplacebyMessageReceive.getExecution().getFinish());
            }
        }
        if (this.destroyedElementsCommands != null && !this.destroyedElementsCommands.isEmpty()) {
            for (ICommand iCommand : this.destroyedElementsCommands) {
                iCommand.undo((IProgressMonitor)new NullProgressMonitor(), null);
            }
        }
        this.oldMessage = null;
        this.oldToReplacebyMessageReceive = null;
        this.oldToReplacebyMessageSent = null;
        this.createdMessageEnds = null;
        this.coveredLifelines = null;
        this.destroyedElementsCommands = null;
        this.setResult(new CommandResult(Status.OK_STATUS));
        return Status.OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult result = this.doExecuteWithResult(monitor, info);
        this.setResult(result);
        return result.getStatus();
    }

    private DestructionOccurrenceSpecification createDestroyReceiveEvent(Message message, Element source) {
        DestructionOccurrenceSpecification sendEvent = this.createDestroyMessageEnd(message, (Lifeline)source);
        sendEvent.setName(message.getName() + "ReceiveDestroyEvent");
        message.setReceiveEvent((MessageEnd)sendEvent);
        return sendEvent;
    }

    private MessageOccurrenceSpecification createSendEvent(Message message, Element source, MessageEnd previous) {
        if (source instanceof Gate) {
            message.setSendEvent((MessageEnd)((Gate)source));
        } else if (source instanceof ExecutionSpecification) {
            if (((ExecutionSpecification)source).getCovereds().size() > 0) {
                Lifeline lifeline = (Lifeline)((ExecutionSpecification)source).getCovereds().get(0);
                MessageOccurrenceSpecification sendEvent = this.createMessageEnd(message, lifeline, previous);
                sendEvent.setName(message.getName() + "SendEvent");
                message.setSendEvent((MessageEnd)sendEvent);
                return sendEvent;
            }
        } else if (source instanceof Lifeline) {
            MessageOccurrenceSpecification sendEvent = this.createMessageEnd(message, (Lifeline)source, previous);
            sendEvent.setName(message.getName() + "SendEvent");
            message.setSendEvent((MessageEnd)sendEvent);
            return sendEvent;
        }
        return null;
    }

    private MessageOccurrenceSpecification createReceiveEvent(Message message, Element target, MessageEnd previous) {
        if (target instanceof Gate) {
            message.setReceiveEvent((MessageEnd)((Gate)target));
        } else if (target instanceof ExecutionSpecification) {
            if (((ExecutionSpecification)target).getCovereds().size() > 0) {
                Lifeline lifeline = (Lifeline)((ExecutionSpecification)target).getCovereds().get(0);
                MessageOccurrenceSpecification receiveEvent = this.createMessageEnd(message, lifeline, previous);
                receiveEvent.setName(message.getName() + "ReceiveEvent");
                message.setReceiveEvent((MessageEnd)receiveEvent);
                return receiveEvent;
            }
        } else if (target instanceof Lifeline) {
            MessageOccurrenceSpecification receiveEvent = this.createMessageEnd(message, (Lifeline)target, previous);
            receiveEvent.setName(message.getName() + "ReceiveEvent");
            message.setReceiveEvent((MessageEnd)receiveEvent);
            return receiveEvent;
        }
        return null;
    }
}

