/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.tree.objects;

import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.BooleanValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.IntegerValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StringValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.UnlimitedNaturalValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.UserPrimitiveTypeValueTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.ValueTreeObject;
import org.eclipse.papyrus.uml.profile.ui.dialogs.InputDialogPrimitiveType;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public abstract class PrimitiveTypeValueTreeObject
extends ValueTreeObject {
    protected PrimitiveTypeValueTreeObject(AppliedStereotypePropertyTreeObject parent, Object value) {
        super(parent, value);
    }

    public static PrimitiveTypeValueTreeObject createInstance(AppliedStereotypePropertyTreeObject parent, Object newValue) {
        Property property = parent.getProperty();
        Type type = property.getType();
        PrimitiveTypeValueTreeObject newVTO = null;
        if (type instanceof PrimitiveType) {
            String typeName = type.getQualifiedName();
            newVTO = typeName.equals("UMLPrimitiveTypes::Boolean") ? new BooleanValueTreeObject(parent, newValue) : (typeName.equals("UMLPrimitiveTypes::String") ? new StringValueTreeObject(parent, newValue) : (typeName.equals("UMLPrimitiveTypes::Integer") ? new IntegerValueTreeObject(parent, newValue) : (typeName.equals("UMLPrimitiveTypes::UnlimitedNatural") ? new UnlimitedNaturalValueTreeObject(parent, newValue) : new UserPrimitiveTypeValueTreeObject(parent, newValue))));
        }
        return newVTO;
    }

    @Override
    public void editMe() {
        AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.getParent();
        Property property = pTO.getProperty();
        Type type = property.getType();
        InputDialogPrimitiveType valueDialog = new InputDialogPrimitiveType(new Shell(), property, this.getValue());
        int val = valueDialog.open();
        if (val == 1) {
            valueDialog.close();
            return;
        }
        String dialogValue = valueDialog.getValue();
        Object newValue = Util.getValueObjectFromString(dialogValue, type);
        pTO.updateValue(pTO.appendMV(newValue));
        valueDialog.close();
    }
}

