/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.labelprovider.service;

import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.infra.services.labelprovider.Activator;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.IQualifierLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ExtensibleLabelProvider
implements ILabelProvider,
IQualifierLabelProvider,
ILabelProviderListener,
IColorProvider,
IFontProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IToolTipProvider {
    private final CopyOnWriteArrayList<ILabelProviderListener> listeners = new CopyOnWriteArrayList();
    private final SortedMap<Integer, List<IFilteredLabelProvider>> providers = new TreeMap<Integer, List<IFilteredLabelProvider>>();
    private final ILabelProvider defaultProvider = new LabelProvider();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void dispose() {
        this.listeners.clear();
        for (List<IFilteredLabelProvider> filteredProviders : this.providers.values()) {
            for (IFilteredLabelProvider provider : filteredProviders) {
                provider.dispose();
            }
        }
        this.providers.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void registerProvider(int priority, IFilteredLabelProvider provider) {
        this.getProviders(priority).add(provider);
        provider.addListener(this);
    }

    public Color getForeground(Object element) {
        IColorProvider provider = this.getProvider(element, IColorProvider.class);
        if (provider != null) {
            return provider.getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element) {
        IColorProvider provider = this.getProvider(element, IColorProvider.class);
        if (provider != null) {
            return provider.getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element) {
        IFontProvider provider = this.getProvider(element, IFontProvider.class);
        if (provider != null) {
            return provider.getFont(element);
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.getProvider(element).getImage(element);
    }

    public String getText(Object element) {
        return this.getProvider(element).getText(element);
    }

    @Override
    public Image getQualifierImage(Object element) {
        Image result = null;
        IQualifierLabelProvider provider = this.getProvider(element, IQualifierLabelProvider.class);
        if (provider != null) {
            result = provider.getQualifierImage(element);
        }
        return result;
    }

    @Override
    public String getQualifierText(Object element) {
        String result = null;
        IQualifierLabelProvider provider = this.getProvider(element, IQualifierLabelProvider.class);
        if (provider != null) {
            result = provider.getQualifierText(element);
        }
        return result;
    }

    protected final ILabelProvider getProvider(Object element) {
        for (List<IFilteredLabelProvider> filteredProviders : this.providers.values()) {
            for (IFilteredLabelProvider provider : filteredProviders) {
                if (!provider.accept(element)) continue;
                return provider;
            }
        }
        return this.defaultProvider;
    }

    protected final <T> T getProvider(Object element, Class<T> type) {
        for (List<IFilteredLabelProvider> filteredProviders : this.providers.values()) {
            for (IFilteredLabelProvider provider : filteredProviders) {
                if (!type.isInstance(provider) || !provider.accept(element)) continue;
                return type.cast(provider);
            }
        }
        return type.isInstance(this.defaultProvider) ? (T)type.cast(this.defaultProvider) : null;
    }

    protected final List<IFilteredLabelProvider> getProviders(int priority) {
        if (!this.providers.containsKey(priority)) {
            this.providers.put(priority, new LinkedList());
        }
        return (List)this.providers.get(priority);
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        if (!this.listeners.isEmpty()) {
            LabelProviderChangedEvent myEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, event.getElements());
            for (ILabelProviderListener listener : this.listeners) {
                try {
                    listener.labelProviderChanged(myEvent);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in label provider listener", (Throwable)e);
                }
            }
        }
    }

    public StyledString getStyledText(Object element) {
        StyledString text = null;
        ILabelProvider provider = this.getProvider(element);
        text = provider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider ? ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)provider).getStyledText(element) : new StyledString(provider.getText(element));
        return text;
    }

    public String getToolTipText(Object element) {
        String text = null;
        ILabelProvider provider = this.getProvider(element);
        if (provider instanceof IToolTipProvider) {
            text = ((IToolTipProvider)provider).getToolTipText(element);
        }
        return text;
    }
}

