/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.clazz.internal.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class InstanceSpecificationLinkUtils {
    public static final String INSTANCE_END = "InstanceEnd";

    private static Set<Classifier> getInheritedClassifier(Classifier classifier, Set<Classifier> alreadyParsedClassifiers) {
        HashSet<Classifier> generalizationClassifiers = new HashSet<Classifier>();
        HashSet<Classifier> parsedClassifiersSet = new HashSet<Classifier>();
        if (alreadyParsedClassifiers != null) {
            parsedClassifiersSet.addAll(alreadyParsedClassifiers);
        }
        if (!parsedClassifiersSet.contains(classifier)) {
            parsedClassifiersSet.add(classifier);
            EList classifierGeneralizations = classifier.parents();
            generalizationClassifiers.addAll((Collection<Classifier>)classifierGeneralizations);
            for (Classifier generalClassifier : classifierGeneralizations) {
                generalizationClassifiers.addAll(InstanceSpecificationLinkUtils.getInheritedClassifier(generalClassifier, parsedClassifiersSet));
            }
        }
        return generalizationClassifiers;
    }

    private static HashSet<Association> getInstanceAssociations(InstanceSpecification instance) {
        HashSet<Association> instanceAssociationsSet = new HashSet<Association>();
        for (Classifier classifier : InstanceSpecificationLinkUtils.getSpecificationClassifier(instance)) {
            instanceAssociationsSet.addAll((Collection<Association>)classifier.getAssociations());
        }
        return instanceAssociationsSet;
    }

    public static Set<Classifier> getSpecificationClassifier(InstanceSpecification instance) {
        HashSet<Classifier> specificationClassicfiersSet = new HashSet<Classifier>();
        for (Classifier classifier : instance.getClassifiers()) {
            if (specificationClassicfiersSet.contains(classifier)) continue;
            specificationClassicfiersSet.add(classifier);
            specificationClassicfiersSet.addAll(InstanceSpecificationLinkUtils.getInheritedClassifier(classifier, null));
        }
        return specificationClassicfiersSet;
    }

    private static Set<Association> getInstanceAssociations(InstanceSpecification sourceInstance, InstanceSpecification targetInstance) {
        HashSet<Association> instanceAssociationsSet = new HashSet<Association>();
        Iterator<Association> sourceAssociationsIterator = InstanceSpecificationLinkUtils.getInstanceAssociations(sourceInstance).iterator();
        Set<Classifier> sourceClassifiers = InstanceSpecificationLinkUtils.getSpecificationClassifier(sourceInstance);
        Set<Classifier> targetClassifiers = InstanceSpecificationLinkUtils.getSpecificationClassifier(targetInstance);
        while (sourceAssociationsIterator.hasNext()) {
            Association nextAssociation = sourceAssociationsIterator.next();
            if (!InstanceSpecificationLinkUtils.checkAssociationEndType(nextAssociation, sourceClassifiers, targetClassifiers)) continue;
            instanceAssociationsSet.add(nextAssociation);
        }
        return instanceAssociationsSet;
    }

    private static boolean checkAssociationEndType(Association association, Set<Classifier> sourceClassifiers, Set<Classifier> targetClassifiers) {
        if (association.getMemberEnds().size() != 2) {
            return false;
        }
        Type sourceAssociationEnd = ((Property)association.getMemberEnds().get(0)).getType();
        Type targetAssociationEnd = ((Property)association.getMemberEnds().get(1)).getType();
        for (Classifier nextSourceClassifier : sourceClassifiers) {
            for (Classifier nextTargetClassifier : targetClassifiers) {
                if ((nextSourceClassifier != sourceAssociationEnd || nextTargetClassifier != targetAssociationEnd) && (nextSourceClassifier != targetAssociationEnd || nextTargetClassifier != sourceAssociationEnd)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<Association> getModelAssociations(InstanceSpecification source, InstanceSpecification target) {
        if (source == null || target == null) {
            return Collections.emptySet();
        }
        return InstanceSpecificationLinkUtils.getInstanceAssociations(source, target);
    }

    public static void addEnd(InstanceSpecification instanceLink, InstanceSpecification end) {
        EAnnotation endtypes = instanceLink.getEAnnotation(INSTANCE_END);
        if (endtypes == null) {
            endtypes = instanceLink.createEAnnotation(INSTANCE_END);
        }
        endtypes.getReferences().add((Object)end);
    }

    public static void setupSlots(Association selectedAssociation, InstanceSpecification instanceSpecification, InstanceSpecification source, InstanceSpecification target, Set<Classifier> sourceSpecificationClassifiersSet, Set<Classifier> targetSpecificationClassifiersSet) {
        if (selectedAssociation == null) {
            return;
        }
        for (Property property : selectedAssociation.getMemberEnds()) {
            Slot slot = UMLFactory.eINSTANCE.createSlot();
            slot.setDefiningFeature((StructuralFeature)property);
            if (sourceSpecificationClassifiersSet.contains(property.getOwner())) {
                source.getSlots().add((Object)slot);
                InstanceSpecificationLinkUtils.associateValue(target, slot, property.getType());
                continue;
            }
            if (targetSpecificationClassifiersSet.contains(property.getOwner())) {
                target.getSlots().add((Object)slot);
                InstanceSpecificationLinkUtils.associateValue(source, slot, property.getType());
                continue;
            }
            instanceSpecification.getSlots().add((Object)slot);
            if (sourceSpecificationClassifiersSet.contains(property.getType())) {
                InstanceSpecificationLinkUtils.associateValue(source, slot, property.getType());
                continue;
            }
            InstanceSpecificationLinkUtils.associateValue(target, slot, property.getType());
        }
    }

    public static InstanceValue associateValue(InstanceSpecification instanceSpecification, Slot owner, Type type) {
        InstanceValue instanceValue = UMLFactory.eINSTANCE.createInstanceValue();
        instanceValue.setName(NamedElementUtil.getDefaultNameWithIncrementFromBase((String)instanceValue.eClass().getName(), (Collection)owner.eContents()));
        instanceValue.setType(type);
        instanceValue.setInstance(instanceSpecification);
        owner.getValues().add((Object)instanceValue);
        return instanceValue;
    }
}

