/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.services;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.properties.uml.services.UMLDocumentationResource;
import org.eclipse.sirius.ext.emf.edit.EditingDomainServices;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertiesHelpContentServices {
    private static final String DOCUMENTATION_ANNOTATION_DETAILS_KEY = "documentation";
    private static final String MULTIPLICITY_DOC_EXAMPLE = "Example of valid formats: 1, 0..12, 1..*, *";
    private static final String MULTIPLICITY_ELEMENT_TYPE = UMLPackage.eINSTANCE.getMultiplicityElement().getName();
    private static final String SOURCE_ANNOTATION_GEN_MODEL = "http://www.eclipse.org/emf/2002/GenModel";
    private static final String SUPERCLASS_DOCUMENTATION_PATTERN = "<p>.*</p>";

    public String getFeatureDescription(EObject obj, String featureName) {
        EStructuralFeature eStructuralFeature;
        EClassifier eClassifier;
        Objects.requireNonNull(obj);
        EPackage uml2ePackage = UMLDocumentationResource.getInstance().getUml2EPackage();
        String description = null;
        if (uml2ePackage != null && (eClassifier = uml2ePackage.getEClassifier(obj.eClass().getName())) instanceof EClass && (eStructuralFeature = ((EClass)eClassifier).getEStructuralFeature(featureName)) != null) {
            EAnnotation eAnnotation = eStructuralFeature.getEAnnotation(SOURCE_ANNOTATION_GEN_MODEL);
            description = this.extractDescriptionFromEAnnotation(eAnnotation);
        }
        if (description == null) {
            EditingDomainServices editServices = new EditingDomainServices();
            description = editServices.getPropertyDescriptorDescription(obj, featureName);
        }
        return description;
    }

    public String getMultiplicityHelpContent(EObject target) {
        EPackage uml2ePackage = UMLDocumentationResource.getInstance().getUml2EPackage();
        String description = "";
        if (uml2ePackage != null) {
            EClassifier multiplicityClassifier = uml2ePackage.getEClassifier(MULTIPLICITY_ELEMENT_TYPE);
            EAnnotation eAnnotation = multiplicityClassifier.getEAnnotation(SOURCE_ANNOTATION_GEN_MODEL);
            description = this.extractDescriptionFromEAnnotation(eAnnotation);
        }
        description = description.concat(MULTIPLICITY_DOC_EXAMPLE);
        return description;
    }

    private String extractDescriptionFromEAnnotation(EAnnotation eAnnotation) {
        String regex;
        Pattern p;
        Matcher m;
        String description = "";
        if (eAnnotation != null && (description = (String)eAnnotation.getDetails().get((Object)DOCUMENTATION_ANNOTATION_DETAILS_KEY)) != null && (m = (p = Pattern.compile(regex = SUPERCLASS_DOCUMENTATION_PATTERN)).matcher(description)).find()) {
            description = description.replaceAll(m.group(0), "");
        }
        return description;
    }
}

