/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.locator;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.papyrus.uml.diagram.activity.figures.AcceptEventActionFigure;
import org.eclipse.papyrus.uml.diagram.activity.figures.OutputPinFigure;
import org.eclipse.papyrus.uml.diagram.activity.figures.PinFigure;
import org.eclipse.papyrus.uml.diagram.activity.helper.ActivityFigureDrawer;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusSendNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.locator.AdvancedBorderItemLocator;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.CallOperationAction;

public class PinPositionLocator
extends AdvancedBorderItemLocator {
    public static final int EXTRA_BORDER_DEFAULT_OFFSET = 8;
    public static final int DEFAULT_PIN_SIZE = 16;
    private static final int SEND_SIGNAL_ACTION_MAX_X = 150;
    private static final int SEND_SIGNAL_ACTION_WIDTH = 200;

    public PinPositionLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public PinPositionLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public PinPositionLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        realLocation.height = realLocation.width = Math.max(realLocation.width, realLocation.height);
        int side = this.findClosestAuthorizedSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    protected Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        int maxLocation;
        Point suggestedCenter = borderItem.getBounds().getCopy().setLocation(suggestedLocation).getCenter();
        suggestedSide = this.redefineSuggestedSide(suggestedCenter, suggestedSide);
        if (this.isInSendSignalAction() && (suggestedSide == 4 || suggestedSide == 1) && suggestedLocation.x > (maxLocation = this.getParentBorder().x + this.getParentBorder().width * 150 / 200 - this.getSize((IFigure)borderItem).width)) {
            suggestedLocation.x = maxLocation;
        }
        Point recommendedLocation = super.locateOnBorder(suggestedLocation, suggestedSide, circuitCount, borderItem);
        return recommendedLocation;
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = this.getSize(borderItem);
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int maxX = 0;
        if (this.isInSendSignalAction() && (suggestedSide == 4 || suggestedSide == 1)) {
            maxX = parentFigureX + parentFigureWidth * 150 / 200 - this.getBorderItemOffset().width;
        }
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        }
        if (maxX > 0 && newX > maxX) {
            newX = maxX;
        }
        return new Point(newX, newY);
    }

    private int redefineSuggestedSide(Point childCenter, int suggestedSide) {
        if (this.isInSendSignalAction()) {
            if (suggestedSide == 16) {
                Point parentCenter = this.getParentBorder().getCenter();
                suggestedSide = childCenter.y < parentCenter.y ? 1 : 4;
            }
        } else if (this.isInAcceptEventAction()) {
            Point parentCenter;
            if (suggestedSide == 8) {
                parentCenter = this.getParentBorder().getCenter();
                suggestedSide = childCenter.y < parentCenter.y ? 1 : 4;
            }
            if (suggestedSide == 16 && this.isInAcceptTimeEventAction()) {
                parentCenter = this.getParentBorder().getCenter();
                suggestedSide = childCenter.y < parentCenter.y ? 1 : 4;
            }
        }
        return suggestedSide;
    }

    public int findClosestAuthorizedSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        int side = PinPositionLocator.findClosestSideOfParent((Rectangle)proposedLocation, (Rectangle)parentBorder);
        side = this.redefineSuggestedSide(proposedLocation.getCenter(), side);
        return side;
    }

    private boolean isInSendSignalAction() {
        IFigure parentFigure = this.getParentFigure();
        for (Object child : parentFigure.getChildren()) {
            if (!(child instanceof PapyrusSendNodeFigure)) continue;
            return true;
        }
        return false;
    }

    private boolean isInAcceptEventAction() {
        IFigure parentFigure = this.getParentFigure();
        for (Object child : parentFigure.getChildren()) {
            if (!(child instanceof AcceptEventActionFigure)) continue;
            ((AcceptEventActionFigure)((Object)child)).isTemplateForAcceptTimeEventActionUsed();
            return true;
        }
        return false;
    }

    private boolean isInAcceptTimeEventAction() {
        IFigure parentFigure = this.getParentFigure();
        for (Object child : parentFigure.getChildren()) {
            if (!(child instanceof AcceptEventActionFigure)) continue;
            return ((AcceptEventActionFigure)((Object)child)).isTemplateForAcceptTimeEventActionUsed();
        }
        return false;
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint().getCopy();
        if (rectSuggested.getTopLeft().x == 0 && rectSuggested.getTopLeft().y == 0) {
            rectSuggested.setLocation(this.getPreferredLocation(borderItem));
        } else {
            rectSuggested.setLocation(rectSuggested.getLocation().translate(this.getParentBorder().getTopLeft()));
        }
        rectSuggested.setSize(size);
        Rectangle validLocation = this.getValidLocation(rectSuggested, borderItem);
        borderItem.setBounds(validLocation);
        this.setCurrentSideOfParent(this.findClosestAuthorizedSideOfParent(borderItem.getBounds(), this.getParentBorder()));
        for (Object subfigure : borderItem.getChildren()) {
            if (!(subfigure instanceof IFigure)) continue;
            for (Object child : ((IFigure)subfigure).getChildren()) {
                this.refreshPinDescriptorArrow(child, MapModeUtil.getMapMode((IFigure)borderItem), size);
            }
        }
    }

    private void refreshPinDescriptorArrow(Object child, IMapMode mapMode, Dimension size) {
        boolean arrowIn = false;
        PolylineShape arrow = null;
        if (child instanceof PinFigure) {
            arrowIn = true;
            arrow = ((PinFigure)((Object)child)).getOptionalArrowFigure();
        }
        if (child instanceof OutputPinFigure) {
            arrowIn = false;
            arrow = ((PinFigure)((Object)child)).getOptionalArrowFigure();
        }
        if (arrow != null && arrow.getPoints().size() > 0) {
            int side = this.getCurrentSideOfParent();
            ActivityFigureDrawer.redrawPinArrow((AbstractPointListShape)arrow, mapMode, size, switch (side) {
                case 1 -> {
                    if (arrowIn) {
                        yield 4;
                    }
                    yield 1;
                }
                case 16 -> {
                    if (arrowIn) {
                        yield 8;
                    }
                    yield 16;
                }
                case 4 -> {
                    if (arrowIn) {
                        yield 1;
                    }
                    yield 4;
                }
                default -> arrowIn ? 16 : 8;
            });
        }
    }

    protected Point getPreferredLocation(int side, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        int x = parentFigureX;
        int y = parentFigureY;
        Dimension borderItemSize = this.getSize(borderItem);
        switch (side) {
            case 1: {
                x += 8 + this.getBorderItemOffset().width;
                y += -borderItemSize.height + this.getBorderItemOffset().height;
                break;
            }
            case 16: {
                x += parentFigureWidth - this.getBorderItemOffset().width;
                y += parentFigureHeight - borderItemSize.height - 8 - this.getBorderItemOffset().height;
                break;
            }
            case 4: {
                x += 8 + this.getBorderItemOffset().width;
                y += parentFigureHeight - this.getBorderItemOffset().height;
                break;
            }
            default: {
                x += -borderItemSize.width + this.getBorderItemOffset().width;
                y += 8 + this.getBorderItemOffset().height;
            }
        }
        return new Point(x, y);
    }

    public static Bounds adaptActionHeight(Bounds boundsConstraint, EObject domainElement) {
        if (domainElement instanceof Action) {
            int pinsOnHeight = 0;
            int numberOfInputs = ((Action)domainElement).getInputs().size();
            int numberOfOutputs = ((Action)domainElement).getOutputs().size();
            pinsOnHeight = domainElement instanceof CallOperationAction ? Math.max(numberOfInputs - 1, numberOfOutputs) : Math.max(numberOfInputs, numberOfOutputs);
            if (pinsOnHeight > 0) {
                int heightInPx = 16 + pinsOnHeight * 24 - 8;
                boundsConstraint.setHeight(heightInPx);
            }
        }
        return boundsConstraint;
    }
}

