/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.uml2.uml.NamedElement;

public final class NamedElementCompletionProposal
implements ICompletionProposal {
    private String displayString;
    private String replacementString;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private Image image;
    private IContextInformation contextInformation;
    private String additionalProposalInfo;
    private EStructuralFeature eStructuralFeature;
    private NamedElement namedElement;
    private EObject context;

    public NamedElementCompletionProposal(EStructuralFeature eStructuralFeature, NamedElement namedElement, EObject context, int replacementOffset, int replacementLength, int cursorPosition) {
        this(eStructuralFeature, namedElement, context, namedElement.getName(), replacementOffset, replacementLength, cursorPosition, null, namedElement.getName() + " - " + namedElement.getNamespace().getQualifiedName(), null, "help?");
    }

    public NamedElementCompletionProposal(EStructuralFeature eStructuralFeature, NamedElement namedElement, EObject context, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.eStructuralFeature = eStructuralFeature;
        this.namedElement = namedElement;
        this.context = context;
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.context);
            RecordingCommand cc = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    NamedElementCompletionProposal.this.context.eSet(NamedElementCompletionProposal.this.eStructuralFeature, (Object)NamedElementCompletionProposal.this.namedElement);
                }
            };
            editingDomain.getCommandStack().execute((Command)cc);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.cursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }
}

