/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.internal.databinding.Util;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStyleValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.uml2.uml.Element;

public class StereotypeAppearanceObservableValue
extends AbstractObservableValue
implements IObserving {
    private static final String DEFAULT_DISPLAY_TYPE = "Text";
    protected static final String DEFAULT_LOCATION = "Compartment";
    protected static final String DEFAULT_ALIGNMENT = "Horizontal";
    protected String propertyPath;
    protected Element element;
    protected EModelElement diagramElement;
    protected TransactionalEditingDomain domain;
    private Adapter diagramElementListener;
    private String cachedValue;

    public StereotypeAppearanceObservableValue(EModelElement diagramElement, Element element, String propertyPath, EditingDomain domain) {
        this.propertyPath = propertyPath;
        this.diagramElement = diagramElement;
        this.element = element;
        this.domain = (TransactionalEditingDomain)domain;
        if (diagramElement != null) {
            diagramElement.eAdapters().add((Object)this.getDiagramElementListener());
        }
    }

    private Adapter getDiagramElementListener() {
        if (this.diagramElementListener == null) {
            this.diagramElementListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!msg.isTouch()) {
                        StereotypeAppearanceObservableValue.this.handleStereotypeChanged(msg);
                    }
                }
            };
        }
        return this.diagramElementListener;
    }

    protected void handleStereotypeChanged(Notification msg) {
        this.setValue(this.doGetValue());
    }

    public Object getValueType() {
        return String.class;
    }

    protected String doGetValue() {
        if (this.propertyPath.equals("stereotypeDisplay")) {
            return this.getStereotypeDisplayValue();
        }
        if (this.propertyPath.equals("textAlignment")) {
            return this.getTextAlignmentValue();
        }
        if (this.propertyPath.equals("displayPlace")) {
            return this.getDisplayPlaceValue();
        }
        return null;
    }

    private String getStereotypeDisplayValue() {
        if (this.diagramElement != null) {
            return NotationUtils.getStringValue((View)((View)this.diagramElement), (String)"displayIcon", (String)DEFAULT_DISPLAY_TYPE);
        }
        return null;
    }

    private String getTextAlignmentValue() {
        if (this.diagramElement != null) {
            return NotationUtils.getStringValue((View)((View)this.diagramElement), (String)"stereotypeAlignment", (String)DEFAULT_ALIGNMENT);
        }
        return null;
    }

    private String getDisplayPlaceValue() {
        if (this.diagramElement != null) {
            return NotationUtils.getStringValue((View)((View)this.diagramElement), (String)"StereotypePropertyLocation", (String)DEFAULT_LOCATION);
        }
        return null;
    }

    protected void doSetValue(Object value) {
        if (value instanceof String) {
            String currentValue;
            String oldValue = this.cachedValue;
            String stringValue = (String)value;
            if (this.diagramElement != null) {
                this.diagramElement.eAdapters().remove((Object)this.diagramElementListener);
            }
            if (!Util.equals((Object)(currentValue = this.doGetValue()), (Object)stringValue)) {
                if (this.propertyPath.equals("stereotypeDisplay")) {
                    this.setStereotypeDisplayValue(stringValue);
                } else if (this.propertyPath.equals("textAlignment")) {
                    this.setTextAlignmentValue(stringValue);
                } else if (this.propertyPath.equals("displayPlace")) {
                    this.setDisplayPlaceValue(stringValue);
                }
            }
            if (!Util.equals((Object)oldValue, (Object)stringValue) && this.hasListeners()) {
                this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)stringValue));
            }
            if (this.diagramElement != null) {
                this.diagramElement.eAdapters().add((Object)this.getDiagramElementListener());
            }
            this.cachedValue = stringValue;
        } else {
            Activator.log.warn("The value " + String.valueOf(value) + " is invalid for property " + this.propertyPath);
        }
    }

    private void setStereotypeDisplayValue(String stereotypeAppearance) {
        if (this.diagramElement instanceof View) {
            CustomStyleValueCommand command = new CustomStyleValueCommand((View)this.diagramElement, (Object)stereotypeAppearance, NotationPackage.eINSTANCE.getStringValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getStringValueStyle_StringValue(), "displayIcon");
            CommandUtil.executeUnsafeCommand((Command)command, (Object)this.domain);
        }
    }

    @Deprecated
    private void setTextAlignmentValue(String alignment) {
        if (this.diagramElement instanceof View) {
            CustomStyleValueCommand command = new CustomStyleValueCommand((View)this.diagramElement, (Object)alignment, NotationPackage.eINSTANCE.getStringValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getStringValueStyle_StringValue(), "stereotypeAlignment");
            CommandUtil.executeUnsafeCommand((Command)command, (Object)this.domain);
        }
    }

    private void setDisplayPlaceValue(String stereotypePlacePresentation) {
        if (this.diagramElement instanceof View) {
            CustomStyleValueCommand command = new CustomStyleValueCommand((View)this.diagramElement, (Object)stereotypePlacePresentation, NotationPackage.eINSTANCE.getStringValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getStringValueStyle_StringValue(), "StereotypePropertyLocation");
            CommandUtil.executeUnsafeCommand((Command)command, (Object)this.domain);
        }
    }

    public Object getObserved() {
        return this.diagramElement;
    }

    public synchronized void dispose() {
        if (this.diagramElement != null && this.diagramElementListener != null) {
            this.diagramElement.eAdapters().remove((Object)this.diagramElementListener);
        }
        super.dispose();
    }
}

