/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.model;

import org.eclipse.papyrus.uml.profile.drafter.ui.model.IModelVisitor;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.LifeStatusKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MemberKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StateKind;
import org.eclipse.uml2.uml.Class;

public class ExtendedStereotypeModel {
    protected MemberKind memberKind = MemberKind.owned;
    protected StateKind stateKind = StateKind.loaded;
    protected LifeStatusKind lifeStatusKind = LifeStatusKind.running;
    protected Class extendedStereotype;
    protected String proposedName;

    public ExtendedStereotypeModel(MemberKind memberKind) {
        this.memberKind = memberKind;
    }

    public ExtendedStereotypeModel(MemberKind memberKind, Class superClass) {
        this.memberKind = memberKind;
        this.stateKind = StateKind.loaded;
        this.extendedStereotype = superClass;
    }

    public ExtendedStereotypeModel(MemberKind memberKind, String proposedName) {
        this.memberKind = memberKind;
        this.stateKind = StateKind.created;
        this.proposedName = proposedName;
    }

    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    public MemberKind getMemberKind() {
        return this.memberKind;
    }

    public StateKind getStateKind() {
        return this.stateKind;
    }

    public LifeStatusKind getLifeStatusKind() {
        return this.lifeStatusKind;
    }

    public void modelChangedEvent() {
        switch (this.stateKind) {
            case loaded: {
                this.stateKind = StateKind.modified;
                break;
            }
        }
    }

    public void deleteModelEvent() {
        switch (this.lifeStatusKind) {
            case running: {
                this.lifeStatusKind = LifeStatusKind.deleted;
                break;
            }
            case deleted: {
                this.lifeStatusKind = LifeStatusKind.running;
                break;
            }
        }
    }
}

