/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.editor.representation.architecture.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.sirius.editor.modelresource.SiriusDiagramModel;
import org.eclipse.papyrus.sirius.editor.representation.architecture.Activator;
import org.eclipse.sirius.diagram.DSemanticDiagram;

public abstract class AbstractCreatePapyrusEditorViewCommand<T extends EObject>
extends RecordingCommand {
    protected final EObject semanticContext;
    protected final EObject graphicalContext;
    protected final boolean openAfterCreation;
    protected final String editorViewName;
    protected final String diagramId;
    protected T createdEditorView;

    public AbstractCreatePapyrusEditorViewCommand(TransactionalEditingDomain domain, String label, String editorViewName, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation, String id) {
        super(domain, label);
        this.semanticContext = semanticContext;
        this.graphicalContext = graphicalContext != null ? graphicalContext : semanticContext;
        this.openAfterCreation = openAfterCreation;
        this.editorViewName = editorViewName;
        this.diagramId = id;
    }

    public AbstractCreatePapyrusEditorViewCommand(TransactionalEditingDomain domain, String label, String editorViewName, EObject semanticContext, boolean openAfterCreation, String diagramId) {
        this(domain, label, editorViewName, semanticContext, null, openAfterCreation, diagramId);
    }

    public final T getCreatedEditorView() {
        return this.createdEditorView;
    }

    protected final void attachToResource(EObject modelElement, DSemanticDiagram diagram) {
        ServicesRegistry sReg = this.getServiceRegistry(modelElement);
        if (sReg == null) {
            return;
        }
        ModelSet modelSet = this.getModelSet(sReg);
        if (modelSet == null) {
            return;
        }
        SiriusDiagramModel model = null;
        try {
            model = (SiriusDiagramModel)modelSet.getModelChecked("org.eclipse.papyrus.sirius.editor.DSemanticDiagram");
        }
        catch (NotFoundException e) {
            Activator.log.error("SiriusDiagramModel not found", (Throwable)e);
            return;
        }
        model.addDiagram(diagram, modelElement);
    }

    protected final ServicesRegistry getServiceRegistry(EObject modelElement) {
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry(modelElement);
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
            return null;
        }
    }

    private ModelSet getModelSet(ServicesRegistry servicesRegistry) {
        try {
            return ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("ModelSet not found", (Throwable)e);
            return null;
        }
    }

    private IPageManager getPageManager(ServicesRegistry servicesRegistry) {
        try {
            return (IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("IPageManager not found", (Throwable)e);
            return null;
        }
    }

    protected final void openEditor(DSemanticDiagram diagram) {
        ServicesRegistry sReg = this.getServiceRegistry(diagram.getTarget());
        if (sReg == null) {
            return;
        }
        IPageManager pageManager = this.getPageManager(sReg);
        if (pageManager == null) {
            return;
        }
        pageManager.openPage((Object)diagram);
        try {
            Object obj4 = ServiceUtilsForEObject.getInstance().getService((Object)"org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer", (Object)diagram);
            if (obj4 instanceof ISashWindowsContainer) {
                ISashWindowsContainer manager = (ISashWindowsContainer)obj4;
                manager.refreshTabs();
            }
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
    }

    public Collection<?> getResult() {
        if (this.createdEditorView != null) {
            return Collections.singleton(this.createdEditorView);
        }
        return Collections.emptyList();
    }
}

