/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;

public class ParameterConstraint
implements UnaryConstraint {
    final String parameterName;
    final EAttribute attribute;

    public ParameterConstraint(String parameterName, EAttribute attribute) {
        this.parameterName = parameterName;
        this.attribute = attribute;
    }

    @Override
    public boolean check(DomainSlot slot) {
        if (!slot.locked) {
            return true;
        }
        Object attributeValue = slot.value.eGet((EStructuralFeature)this.attribute);
        if (!slot.conditionHandler.isSet(this.parameterName)) {
            boolean ok = slot.conditionHandler.setParameter(this.parameterName, attributeValue);
            if (!ok) {
                slot.conditionHandler.unsetParameter(this.parameterName);
            }
            return ok;
        }
        Object parameterValue = slot.conditionHandler.getParameter(this.parameterName);
        if (parameterValue != null) {
            return parameterValue.equals(attributeValue);
        }
        return attributeValue == null;
    }
}

