/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.text.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.StateValidator;
import org.eclipse.emf.henshin.statespace.ValidationResult;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.helper.OCLHelper;

public class OCLStateValidator
implements StateValidator {
    public static final String VALIDATOR_ID = "org.eclipse.emf.henshin.statespace.validators.ocl";
    private String property;
    private StateSpaceIndex index;
    private OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> ocl = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);
    private OCLHelper<EClassifier, ?, ?, Constraint> helper = this.ocl.createOCLHelper();
    private Constraint constraint;
    private EClassifier classifier;

    public static void register() {
        StateSpacePlugin.INSTANCE.getValidators().put(VALIDATOR_ID, new OCLStateValidator());
    }

    @Override
    public ValidationResult validate(State state, IProgressMonitor monitor) throws Exception {
        Model model = this.index.getModel(state);
        for (EObject root : model.getResource().getContents()) {
            if (this.constraint == null || this.classifier != root.eClass()) {
                this.classifier = root.eClass();
                this.helper.setContext((Object)this.classifier);
                try {
                    this.constraint = (Constraint)this.helper.createInvariant(this.property);
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem in property \"" + this.property + "\": " + e.getMessage(), e);
                }
            }
            if (this.ocl.check((Object)root, (Object)this.constraint)) continue;
            monitor.done();
            return ValidationResult.INVALID;
        }
        monitor.done();
        return ValidationResult.VALID;
    }

    @Override
    public void setProperty(String property) throws ParseException {
        this.property = property;
        this.constraint = null;
    }

    @Override
    public void setStateSpaceIndex(StateSpaceIndex index) {
        this.index = index;
    }

    @Override
    public String getName() {
        return "OCL";
    }

    @Override
    public boolean usesProperty() {
        return true;
    }
}

