/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.migration.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MigrationWizardPage
extends WizardPage {
    private Text henshinDiagramFileText;
    private Text henshinFileText;
    protected IFile selectedHenshinFile = null;
    protected IFile selectedDiagramFile = null;
    protected boolean optimizeNestedConditions = true;
    protected boolean retainKernelAndMultiRules = false;
    protected boolean migrateDiagramFile = false;

    public MigrationWizardPage(IFile initialHenshinFile) {
        super("wizardPage");
        this.setTitle("Henshin migration");
        this.setDescription("Migrate old henshin files and diagrams to the new henshin version");
        if (initialHenshinFile != null) {
            this.selectedHenshinFile = initialHenshinFile;
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblHenshinFileTo = new Label(container, 0);
        lblHenshinFileTo.setLayoutData((Object)new GridData(32));
        lblHenshinFileTo.setText("Henshin file to migrate:");
        this.henshinFileText = new Text(container, 2048);
        this.henshinFileText.setLayoutData((Object)new GridData(256));
        this.henshinFileText.setEditable(false);
        this.henshinFileText.setText(this.selectedHenshinFile == null ? "" : this.selectedHenshinFile.getFullPath().toString());
        Button changeHenshinFileButton = new Button(container, 0);
        changeHenshinFileButton.setLayoutData((Object)new GridData(128));
        changeHenshinFileButton.setText("Select");
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        final Button OptimizeNestedConditionsCheck = new Button(container, 32);
        OptimizeNestedConditionsCheck.setSelection(this.optimizeNestedConditions);
        OptimizeNestedConditionsCheck.setLayoutData((Object)data);
        OptimizeNestedConditionsCheck.setText("Optimize nested conditions");
        final Button btnRetainSeparateKernel = new Button(container, 32);
        btnRetainSeparateKernel.setSelection(this.retainKernelAndMultiRules);
        btnRetainSeparateKernel.setLayoutData((Object)data);
        btnRetainSeparateKernel.setText("Keep separate kernel and multi-rules");
        if (this.selectedHenshinFile != null) {
            String diagramName = this.selectedHenshinFile.getName().replaceFirst(".henshin", ".henshin_diagram");
            IResource diagramFile = this.selectedHenshinFile.getParent().findMember(diagramName);
            if (diagramFile instanceof IFile && diagramFile.exists()) {
                this.selectedDiagramFile = (IFile)diagramFile;
                this.migrateDiagramFile = true;
            }
        }
        final Button MigrateDiagramFileCheck = new Button(container, 32);
        MigrateDiagramFileCheck.setSelection(this.selectedDiagramFile != null);
        MigrateDiagramFileCheck.setLayoutData((Object)data);
        MigrateDiagramFileCheck.setText("Migrate corresponding diagram file");
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(32));
        lblNewLabel.setText("Diagram file to migrate:");
        this.henshinDiagramFileText = new Text(container, 2048);
        this.henshinDiagramFileText.setLayoutData((Object)new GridData(256));
        this.henshinDiagramFileText.setEditable(false);
        this.henshinDiagramFileText.setEnabled(this.selectedDiagramFile != null);
        if (this.selectedDiagramFile != null) {
            this.henshinDiagramFileText.setText(this.selectedDiagramFile.getFullPath().toString());
            this.migrateDiagramFile = true;
        } else {
            this.migrateDiagramFile = false;
        }
        final Button changeDiagramFileButton = new Button(container, 0);
        changeDiagramFileButton.setLayoutData((Object)new GridData(32));
        changeDiagramFileButton.setText("Select");
        changeDiagramFileButton.setEnabled(this.selectedDiagramFile != null);
        MigrateDiagramFileCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationWizardPage.this.henshinDiagramFileText.setEnabled(MigrateDiagramFileCheck.getSelection());
                changeDiagramFileButton.setEnabled(MigrateDiagramFileCheck.getSelection());
                MigrationWizardPage.this.migrateDiagramFile = MigrateDiagramFileCheck.getSelection();
            }
        });
        changeDiagramFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationWizardPage.this.selectedDiagramFile = WorkspaceResourceDialog.openFileSelection((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"henshin migration", (String)"select henshin diagram file to migrate", (boolean)false, null, null)[0];
                if (MigrationWizardPage.this.selectedDiagramFile != null) {
                    MigrationWizardPage.this.henshinDiagramFileText.setText(MigrationWizardPage.this.selectedDiagramFile.getName());
                }
            }
        });
        changeHenshinFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationWizardPage.this.selectedHenshinFile = WorkspaceResourceDialog.openFileSelection((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"henshin migration", (String)"select henshin file to migrate", (boolean)false, null, null)[0];
                if (MigrationWizardPage.this.selectedHenshinFile != null) {
                    MigrationWizardPage.this.henshinFileText.setText(MigrationWizardPage.this.selectedHenshinFile.getName());
                }
            }
        });
        OptimizeNestedConditionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationWizardPage.this.optimizeNestedConditions = OptimizeNestedConditionsCheck.getSelection();
            }
        });
        btnRetainSeparateKernel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationWizardPage.this.retainKernelAndMultiRules = btnRetainSeparateKernel.getSelection();
            }
        });
        this.setControl((Control)container);
    }
}

