/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class CreateParameterMappingCommand
extends AbstractCommand {
    protected Parameter source;
    protected Parameter target;
    TransformationUnit sourceUnit;
    TransformationUnit targetUnit;
    TransformationUnit ownerUnit;
    protected ParameterMapping mapping;
    protected Collection<?> affectedObjects;

    public CreateParameterMappingCommand(Parameter source, Parameter target) {
        this.source = source;
        this.target = target;
    }

    public boolean isEnabled() {
        if (this.canExecute()) {
            for (ParameterMapping pm : this.ownerUnit.getParameterMappings()) {
                if (!pm.getSource().equals(this.source) || !pm.getTarget().equals(this.target)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean prepare() {
        if (QuantUtil.anyNull(this.source, this.target) || QuantUtil.allIdentical(this.source, this.target)) {
            return false;
        }
        this.sourceUnit = this.source.getUnit();
        this.targetUnit = this.target.getUnit();
        this.ownerUnit = this.sourceUnit.getSubUnits(false).contains((Object)this.targetUnit) ? this.sourceUnit : (this.targetUnit.getSubUnits(false).contains((Object)this.sourceUnit) ? this.targetUnit : null);
        return this.ownerUnit != null;
    }

    public void execute() {
        this.mapping = HenshinFactory.eINSTANCE.createParameterMapping();
        this.mapping.setSource(this.source);
        this.mapping.setTarget(this.target);
        this.redo();
    }

    public void redo() {
        this.ownerUnit.getParameterMappings().add((Object)this.mapping);
        this.affectedObjects = Collections.singleton(this.mapping);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.ownerUnit.getParameterMappings().remove((Object)this.mapping);
        ArrayList pList = new ArrayList();
        pList.add(this.source);
        pList.add(this.target);
        this.affectedObjects = pList;
    }

    public Collection<?> getAffectedObjects() {
        return this.affectedObjects;
    }
}

