/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.statespace.Path;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.Transition;

public class StateSpaceSearch {
    private final Set<State> visited = new HashSet<State>();
    private Path path;
    private State current;

    protected boolean shouldStop(State current, Path path) {
        return false;
    }

    public synchronized boolean depthFirst(List<State> states, boolean reverse) {
        this.reset();
        for (State state : states) {
            if (!this.depthFirst(state, reverse)) continue;
            return true;
        }
        return false;
    }

    public boolean depthFirst(StateSpace stateSpace, boolean reverse) {
        return this.depthFirst((List<State>)stateSpace.getInitialStates(), reverse);
    }

    public boolean depthFirst(State state, boolean reverse) {
        this.current = state;
        this.path = new Path(state);
        return this.depthFirst(reverse);
    }

    private boolean depthFirst(boolean reverse) {
        if (this.visited(this.current)) {
            return false;
        }
        if (this.shouldStop(this.current, this.path)) {
            return true;
        }
        List<Transition> transitions = this.getNextTransitions(this.current, reverse);
        if (transitions.isEmpty()) {
            return false;
        }
        this.path.add(transitions.get(0));
        while (!this.path.isEmpty()) {
            Transition transition = reverse ? (Transition)this.path.getFirst() : (Transition)this.path.getLast();
            State previous = reverse ? transition.getTarget() : transition.getSource();
            this.current = reverse ? transition.getSource() : transition.getTarget();
            Transition nextTransition = null;
            if (this.visited(this.current)) {
                if (reverse) {
                    this.path.removeFirst();
                } else {
                    this.path.removeLast();
                }
                transitions = this.getNextTransitions(previous, reverse);
                int index = transitions.indexOf(transition);
                if (index + 1 < transitions.size()) {
                    nextTransition = transitions.get(index + 1);
                }
            } else {
                if (this.shouldStop(this.current, this.path)) {
                    return true;
                }
                transitions = this.getNextTransitions(this.current, reverse);
                if (!transitions.isEmpty()) {
                    nextTransition = transitions.get(0);
                }
            }
            if (nextTransition == null) continue;
            if (reverse) {
                this.path.addFirst(nextTransition);
                continue;
            }
            this.path.addLast(nextTransition);
        }
        return false;
    }

    public void reset() {
        this.visited.clear();
    }

    private List<Transition> getNextTransitions(State state, boolean reverse) {
        return reverse ? state.getIncoming() : state.getOutgoing();
    }

    private boolean visited(State state) {
        if (this.visited.contains(state)) {
            return true;
        }
        this.visited.add(state);
        return false;
    }

    public static List<State> removeUnreachableStates(StateSpace stateSpace) {
        StateSpaceSearch search = new StateSpaceSearch();
        search.depthFirst(stateSpace, false);
        EList<State> states = stateSpace.getStates();
        ArrayList<State> removed = new ArrayList<State>();
        Set<State> visited = search.getVisitedStates();
        int numUnreached = states.size() - visited.size();
        if (numUnreached == 0) {
            return removed;
        }
        int i = 0;
        while (i < states.size()) {
            State state = (State)states.get(i);
            if (!visited.contains(state)) {
                stateSpace.removeState(state);
                removed.add(state);
                if (removed.size() == numUnreached) break;
                --i;
            }
            ++i;
        }
        return removed;
    }

    public static Path findPath(StateSpace stateSpace, final List<String> trace) {
        final int length = trace.size();
        StateSpaceSearch search = new StateSpaceSearch(){

            @Override
            protected boolean shouldStop(State current, Path path) {
                if (path.size() == length) {
                    ArrayList<Transition> transitions = new ArrayList<Transition>(path);
                    int i = 0;
                    while (i < length) {
                        if (!((String)trace.get(i)).equals(((Transition)transitions.get(i)).getLabel())) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }
        };
        if (!search.depthFirst(stateSpace, false)) {
            return null;
        }
        return search.getPath();
    }

    public Set<State> getVisitedStates() {
        return this.visited;
    }

    public State getCurrentState() {
        return this.current;
    }

    public Path getPath() {
        return this.path;
    }
}

