/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.diagram.part.HenshinCreationWizardPage;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorUtil;
import org.eclipse.emf.henshin.diagram.part.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class HenshinCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected HenshinCreationWizardPage diagramModelFilePage;
    protected HenshinCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.HenshinCreationWizardTitle);
        this.setDefaultPageImageDescriptor(HenshinDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewHenshinWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new HenshinCreationWizardPage("DiagramModelFile", this.getSelection(), "henshin_diagram");
        this.diagramModelFilePage.setTitle(Messages.HenshinCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.HenshinCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new HenshinCreationWizardPage("DomainModelFile", this.getSelection(), "henshin"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = HenshinCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".henshin_diagram".length());
                    this.setFileName(HenshinDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "henshin"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.HenshinCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.HenshinCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                HenshinCreationWizard.this.diagram = HenshinDiagramEditorUtil.createDiagram(HenshinCreationWizard.this.diagramModelFilePage.getURI(), HenshinCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (HenshinCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && HenshinCreationWizard.this.diagram != null) {
                    try {
                        HenshinDiagramEditorUtil.openDiagram(HenshinCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)HenshinCreationWizard.this.getContainer().getShell(), (String)Messages.HenshinCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.HenshinCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                HenshinDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

