/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.henshin.diagram.edit.helpers.HenshinBaseEditHelper;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.View;

public class UnitEditHelper
extends HenshinBaseEditHelper {
    public static List<View> getInvocationViews(View unitView, boolean withNulls) {
        if (String.valueOf(7003).equals(unitView.getType())) {
            unitView = (View)unitView.eContainer();
        }
        View unitCompartment = ViewUtil.getChildBySemanticHint((View)unitView, (String)String.valueOf(7003));
        TransformationUnit unit = (TransformationUnit)unitView.getElement();
        List<TransformationUnit> subUnits = UnitEditHelper.getSubUnitsWithNulls(unit);
        ArrayList<View> invocations = new ArrayList<View>(subUnits.size());
        for (TransformationUnit subUnit : subUnits) {
            invocations.add(UnitEditHelper.getInvocationView(unitCompartment, subUnit, invocations));
        }
        return invocations;
    }

    public static View getInvocationView(View unitView, InvocationViewKey key) {
        return UnitEditHelper.getInvocationViews(unitView, true).get(key.index);
    }

    private static List<TransformationUnit> getSubUnitsWithNulls(TransformationUnit unit) {
        ArrayList<TransformationUnit> subUnits = new ArrayList<TransformationUnit>();
        if (unit instanceof ConditionalUnit) {
            subUnits.add(((ConditionalUnit)unit).getIf());
            subUnits.add(((ConditionalUnit)unit).getThen());
            subUnits.add(((ConditionalUnit)unit).getElse());
        } else if (unit instanceof LoopUnit) {
            subUnits.add(((LoopUnit)unit).getSubUnit());
        } else if (unit instanceof IteratedUnit) {
            subUnits.add(((IteratedUnit)unit).getSubUnit());
        } else {
            subUnits.addAll((Collection<TransformationUnit>)unit.getSubUnits(false));
        }
        return subUnits;
    }

    private static View getInvocationView(View unitCompartment, TransformationUnit target, Collection<View> exclude) {
        if (unitCompartment == null || target == null) {
            return null;
        }
        for (Object obj : unitCompartment.getChildren()) {
            View view = (View)obj;
            if (view.getElement() != target || !String.valueOf(3003).equals(view.getType()) || exclude.contains(view)) continue;
            return view;
        }
        return null;
    }

    public static View getUnitCompartment(View view) {
        String type = HenshinVisualIDRegistry.getType(7003);
        if (type.equals(view.getType())) {
            return view;
        }
        return ViewUtil.getChildBySemanticHint((View)view, (String)type);
    }

    public static enum InvocationViewKey {
        IF(0),
        THEN(1),
        ELSE(2),
        LOOP(0),
        ITERATE(0);

        private int index;

        private InvocationViewKey(int index) {
            this.index = index;
        }
    }
}

