/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

public class RuleChangeInfo {
    private Collection<Node> createdNodes = new ArrayList<Node>();
    private Collection<Node> deletedNodes;
    private Collection<Node> preservedNodes;
    private Collection<Edge> createdEdges = new ArrayList<Edge>();
    private Collection<Edge> deletedEdges = new ArrayList<Edge>();
    private Collection<Attribute> attributeChanges;

    public RuleChangeInfo(Rule rule) {
        this.deletedNodes = new ArrayList<Node>();
        this.attributeChanges = new ArrayList<Attribute>();
        this.preservedNodes = new ArrayList<Node>();
        for (Node node : rule.getLhs().getNodes()) {
            if (HenshinMappingUtil.isNodeMapped((Collection)rule.getMultiMappings(), (Node)node) || HenshinMappingUtil.isNodeMapped((Collection)rule.getMappings(), (Node)node)) continue;
            this.deletedNodes.add(node);
        }
        for (Node node : rule.getRhs().getNodes()) {
            if (HenshinMappingUtil.isNodeMapped((Collection)rule.getMultiMappings(), (Node)node)) continue;
            if (!HenshinMappingUtil.isNodeMapped((Collection)rule.getMappings(), (Node)node)) {
                this.createdNodes.add(node);
            } else {
                this.preservedNodes.add(node);
            }
            for (Attribute attribute : node.getAttributes()) {
                this.attributeChanges.add(attribute);
            }
        }
        for (Edge edge : rule.getLhs().getEdges()) {
            if (HenshinMappingUtil.isEdgeMapped((List)rule.getMultiMappings(), (Edge)edge) || HenshinMappingUtil.isEdgeMapped((List)rule.getMappings(), (Edge)edge)) continue;
            this.deletedEdges.add(edge);
        }
        for (Edge edge : rule.getRhs().getEdges()) {
            if (HenshinMappingUtil.isEdgeMapped((List)rule.getMultiMappings(), (Edge)edge) || HenshinMappingUtil.isEdgeMapped((List)rule.getMappings(), (Edge)edge)) continue;
            this.createdEdges.add(edge);
        }
    }

    public Collection<Node> getCreatedNodes() {
        return this.createdNodes;
    }

    public Collection<Node> getPreservedNodes() {
        return this.preservedNodes;
    }

    public Collection<Edge> getCreatedEdges() {
        return this.createdEdges;
    }

    public Collection<Edge> getDeletedEdges() {
        return this.deletedEdges;
    }

    public Collection<Attribute> getAttributeChanges() {
        return this.attributeChanges;
    }

    public Collection<Node> getDeletedNodes() {
        return this.deletedNodes;
    }
}

