/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.AssignmentImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class MatchImpl
extends AssignmentImpl
implements Match {
    protected List<Node> nodes;

    public MatchImpl(Rule rule) {
        this(rule, false);
    }

    public MatchImpl(Rule rule, boolean isResultMatch) {
        super((TransformationUnit)rule, isResultMatch);
    }

    public MatchImpl(Assignment assignment, boolean isResultMatch) {
        super(assignment.getUnit(), isResultMatch);
        this.copyParameterValues(assignment);
        if (assignment instanceof Match) {
            Match match = (Match)assignment;
            for (Node node : this.nodes) {
                this.setNodeTarget(node, match.getNodeTarget(node));
            }
        }
    }

    @Override
    protected void setUnit(TransformationUnit unit) {
        if (!(unit instanceof Rule)) {
            throw new IllegalArgumentException("Transformation unit must be a rule");
        }
        this.unit = unit;
        this.nodes = this.isResultAssignment ? ((Rule)unit).getRhs().getNodes() : ((Rule)unit).getLhs().getNodes();
    }

    @Override
    public Rule getRule() {
        return (Rule)this.unit;
    }

    @Override
    public EObject getNodeTarget(Node node) {
        return (EObject)this.values.get(node);
    }

    @Override
    public void setNodeTarget(Node node, EObject target) {
        Parameter param;
        this.setValue(node, target);
        if (this.unit != null && node.getName() != null && (param = this.unit.getParameterByName(node.getName())) != null) {
            this.setValue(param, target);
        }
    }

    @Override
    public void setParameterValue(Parameter param, Object value) {
        this.setValue(param, value);
        String name = param.getName();
        if (name != null && this.nodes != null && (value == null || value instanceof EObject)) {
            for (Node node : this.nodes) {
                if (!name.equals(node.getName())) continue;
                this.setValue(node, value);
            }
        }
    }

    @Override
    public List<EObject> getNodeTargets() {
        ArrayList<EObject> targets = new ArrayList<EObject>();
        if (this.nodes != null) {
            for (Node node : this.nodes) {
                EObject tar = (EObject)this.values.get(node);
                if (tar == null) continue;
                targets.add(tar);
            }
        }
        return targets;
    }

    @Override
    public List<Match> getNestedMatches(Rule multiRule) {
        ArrayList nested = (ArrayList)this.values.get(multiRule);
        if (nested == null) {
            nested = new ArrayList();
            this.values.put(multiRule, nested);
        }
        return nested;
    }

    @Override
    public boolean overlapsWith(Match match) {
        List<EObject> common = this.getNodeTargets();
        common.retainAll(match.getNodeTargets());
        return !common.isEmpty();
    }

    @Override
    public boolean isComplete() {
        if (this.nodes == null || this.getRule() == null) {
            return false;
        }
        if (!this.values.keySet().containsAll(this.nodes)) {
            return false;
        }
        for (Rule multiRule : this.getRule().getMultiRules()) {
            for (Match nestedMatch : this.getNestedMatches(multiRule)) {
                if (nestedMatch.isComplete()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValid() {
        if (!this.isComplete()) {
            return false;
        }
        for (Node node : this.nodes) {
            if (!node.getType().isSuperTypeOf(((EObject)this.values.get(node)).eClass())) continue;
            return false;
        }
        for (Node node : this.nodes) {
            EObject source = (EObject)this.values.get(node);
            for (Edge edge : node.getOutgoing()) {
                List targetObjects;
                EReference edgeType = edge.getType();
                EObject target = (EObject)this.values.get(edge.getTarget());
                if (!(edgeType.isMany() ? !(targetObjects = (List)source.eGet((EStructuralFeature)edgeType)).contains(target) : source.eGet((EStructuralFeature)edgeType) != target)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof Match)) {
            return false;
        }
        Match match = (Match)obj;
        if (this.nodes != null) {
            for (Node node : this.nodes) {
                if (this.values.get(node) == match.getNodeTarget(node)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isResultMatch() {
        return this.isResultAssignment;
    }

    @Override
    public String toString() {
        if (this.isResultAssignment) {
            return "Result match for rule '" + this.unit.getName() + "':\n" + this.toStringWithIndent("");
        }
        return "Match for rule '" + this.unit.getName() + "':\n" + this.toStringWithIndent("");
    }

    @Override
    protected String toStringWithIndent(String indent) {
        String name;
        String result = super.toStringWithIndent(indent);
        if (this.nodes.isEmpty()) {
            return String.valueOf(indent) + "- no nodes\n";
        }
        int index = 1;
        for (Node node : this.nodes) {
            name = node.getName() != null ? "'" + node.getName() + "'" : "#" + index;
            EObject target = this.getNodeTarget(node);
            if (target != null) {
                result = String.valueOf(result) + indent + "- node " + name + " => " + InterpreterUtil.objectToString(target) + "\n";
            }
            ++index;
        }
        index = 1;
        for (Rule multiRule : ((Rule)this.unit).getMultiRules()) {
            name = multiRule.getName() != null ? "'" + multiRule.getName() + "'" : "#" + index;
            result = String.valueOf(result) + "\n" + indent + "  Multi-rule " + name + ":\n";
            List<Match> matches = this.getNestedMatches(multiRule);
            int i = 0;
            while (i < matches.size()) {
                result = String.valueOf(result) + "\n" + indent + "  Match #" + i + ":\n";
                Match match = matches.get(i);
                result = match instanceof MatchImpl ? String.valueOf(result) + ((MatchImpl)match).toStringWithIndent(String.valueOf(indent) + "  ") : String.valueOf(result) + indent + "  " + match.toString();
                ++i;
            }
            ++index;
        }
        return result;
    }
}

