/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.external.cadp.AUTStateSpaceExporter;
import org.eclipse.emf.henshin.statespace.validation.AbstractStateSpaceValidator;

public abstract class AbstractFileBasedValidator
extends AbstractStateSpaceValidator {
    public static final String AUT_FILE_EXPORT_KEY = "aut-export";
    private Map<StateSpace, Map<String, File>> fileCache = new HashMap<StateSpace, Map<String, File>>();
    private Adapter cacheAdapter = new AdapterImpl(){

        public void notifyChanged(Notification event) {
            AbstractFileBasedValidator.this.clearCachedFiles((StateSpace)event.getNotifier());
        }
    };

    protected void addCachedFile(StateSpace stateSpace, String key, File file) {
        Map<String, File> files = this.fileCache.get(stateSpace);
        if (files == null) {
            files = new HashMap<String, File>();
            this.fileCache.put(stateSpace, files);
        }
        if (files.containsKey(key)) {
            files.get(key).delete();
        }
        files.put(key, file);
        if (!stateSpace.eAdapters().contains((Object)this.cacheAdapter)) {
            stateSpace.eAdapters().add((Object)this.cacheAdapter);
        }
    }

    protected File getCachedFile(StateSpace stateSpace, String key) {
        Map<String, File> files = this.fileCache.get(stateSpace);
        if (files == null) {
            return null;
        }
        File file = files.get(key);
        if (file != null && file.exists()) {
            return file;
        }
        files.remove(key);
        return null;
    }

    protected void clearCachedFiles(StateSpace stateSpace) {
        Map<String, File> files = this.fileCache.remove(stateSpace);
        if (files != null) {
            for (File file : files.values()) {
                file.delete();
            }
        }
        stateSpace.eAdapters().remove((Object)this.cacheAdapter);
    }

    protected File exportAsAUT(StateSpace stateSpace, IProgressMonitor monitor) throws IOException {
        File cached = this.getCachedFile(stateSpace, AUT_FILE_EXPORT_KEY);
        if (cached != null) {
            monitor.done();
            return cached;
        }
        String basename = stateSpace.eResource().getURI().trimFileExtension().lastSegment();
        File aut = File.createTempFile(basename, ".aut");
        URI uri = URI.createFileURI((String)aut.getAbsolutePath());
        AUTStateSpaceExporter exporter = new AUTStateSpaceExporter();
        exporter.export(stateSpace, uri, monitor);
        this.addCachedFile(stateSpace, AUT_FILE_EXPORT_KEY, aut);
        return aut;
    }

    protected void convertFile(File input, File output, IProgressMonitor monitor, String ... command) throws Exception {
        int exit;
        String label = "Running " + command[0] + "...";
        monitor.beginTask(label, 1);
        monitor.subTask(label);
        command = Arrays.copyOf(command, command.length + 2);
        command[command.length - 2] = input.getAbsolutePath();
        command[command.length - 1] = output.getAbsolutePath();
        Process process = Runtime.getRuntime().exec(command);
        int wait = 50;
        while (true) {
            if (monitor.isCanceled()) {
                process.destroy();
                exit = 0;
                break;
            }
            try {
                exit = process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {}
                wait = (int)((double)wait * 1.1);
                continue;
            }
            break;
        }
        if (exit != 0) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String out = "";
            while ((line = reader.readLine()) != null) {
                out = String.valueOf(out) + "\n" + line;
            }
            throw new RuntimeException(String.valueOf(command[0]) + " returned exit code " + exit + ":\n" + out);
        }
        process.destroy();
        monitor.worked(1);
        monitor.done();
    }

    protected File createTempFile(String prefix, String suffix, String content) throws IOException {
        File temp = File.createTempFile(prefix, suffix);
        FileWriter writer = new FileWriter(temp);
        writer.write(content);
        writer.close();
        return temp;
    }

    protected boolean isWindows() {
        return "win32".equals(Platform.getOS());
    }
}

