/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.diagram.edit.actions.NodeActionHelper;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;
import org.eclipse.emf.henshin.model.util.HenshinNACUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;

public class AttributeCreateCommand
extends EditElementCommand {
    public AttributeCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        Node node = (Node)this.getElementToEdit();
        return node.getType() != null && !node.getType().getEAllAttributes().isEmpty();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Node node = (Node)this.getElementToEdit();
        Rule rule = node.getGraph().getContainerRule();
        Node lhsNode = NodeActionHelper.INSTANCE.getLhsNode(node);
        Attribute attribute = HenshinFactory.eINSTANCE.createAttribute();
        if (node.getType() != null) {
            for (EAttribute type : node.getType().getEAllAttributes()) {
                if (node.findAttributeByType(type) != null) continue;
                attribute.setType(type);
                attribute.setValue(String.valueOf(type.getDefaultValue()));
                break;
            }
        }
        node.getAttributes().add((Object)attribute);
        if (lhsNode != null) {
            Node rhsNode = HenshinMappingUtil.getNodeImage((Node)lhsNode, (Graph)rule.getRhs(), (List)rule.getMappings());
            if (rhsNode != null) {
                this.addAttribute(rhsNode, (Attribute)EcoreUtil.copy((EObject)attribute));
            }
            for (NestedCondition nac : HenshinNACUtil.getAllNACs((Rule)rule)) {
                Node nacNode = HenshinMappingUtil.getNodeImage((Node)lhsNode, (Graph)nac.getConclusion(), (List)nac.getMappings());
                if (nacNode == null) continue;
                this.addAttribute(nacNode, (Attribute)EcoreUtil.copy((EObject)attribute));
            }
        }
        this.doConfigure(attribute, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)attribute);
        return CommandResult.newOKCommandResult((Object)attribute);
    }

    private void addAttribute(Node node, Attribute attribute) {
        Attribute old = node.findAttributeByType(attribute.getType());
        if (old != null) {
            node.getAttributes().set(node.getAttributes().indexOf((Object)old), (Object)attribute);
        } else {
            node.getAttributes().add((Object)attribute);
        }
    }

    protected void doConfigure(Attribute newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

