/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.GenericActionHelper;
import org.eclipse.emf.henshin.diagram.edit.actions.NodeActionHelper;
import org.eclipse.emf.henshin.diagram.edit.maps.AttributeMapEditor;
import org.eclipse.emf.henshin.diagram.edit.maps.MapEditor;
import org.eclipse.emf.henshin.diagram.edit.maps.NodeMapEditor;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinNACUtil;

public class AttributeActionHelper
extends GenericActionHelper<Attribute, Node> {
    public static final AttributeActionHelper INSTANCE = new AttributeActionHelper();

    @Override
    public List<Attribute> getActionElements(Node node, Action action) {
        Rule rule = node.getGraph().getContainerRule();
        ArrayList candidates = new ArrayList();
        Node lhsNode = NodeActionHelper.INSTANCE.getLhsNode(node);
        if (lhsNode != null) {
            candidates.addAll(lhsNode.getAttributes());
            Node rhsNode = new NodeMapEditor(rule.getRhs()).getOpposite(lhsNode);
            if (rhsNode != null) {
                candidates.addAll(rhsNode.getAttributes());
            }
            for (NestedCondition nac : HenshinNACUtil.getAllNACs((Rule)rule)) {
                Node nacNode = new NodeMapEditor(nac.getConclusion()).getOpposite(lhsNode);
                if (nacNode == null) continue;
                candidates.addAll(nacNode.getAttributes());
            }
        } else {
            candidates.addAll(node.getAttributes());
        }
        return this.filterElementsByAction(candidates, action);
    }

    @Override
    protected MapEditor<Attribute> getMapEditor(Graph target) {
        return new AttributeMapEditor(target);
    }

    @Override
    protected MapEditor<Attribute> getMapEditor(Graph source, Graph target, List<Mapping> mappings) {
        return new AttributeMapEditor(source, target, mappings);
    }
}

