/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.matching.EmfGraph;

public class ElementGroups {
    public static void assertElementGroupDeleted(Collection<? extends EObject> group, EmfGraph graph) throws AssertionError {
        if (graph.geteObjects().containsAll(group)) {
            throw new AssertionError((Object)"expected: Any element in the specified element group deleted, but group still exists in its entirety.");
        }
    }

    public static void assertAllElementsFromElementGroupDeleted(Collection<? extends EObject> group, EmfGraph graph) throws AssertionError {
        ElementGroups.assertElementGroupDeleted(group, graph);
        Collection graphObjects = graph.geteObjects();
        for (EObject eObject : group) {
            if (graphObjects.contains(eObject)) {
                throw new AssertionError((Object)"expected: All elements from the specified group deleted, but at least one element still exists in graph.");
            }
        }
    }

    public static void assertNoElementFromElementGroupDeleted(Collection<? extends EObject> group, EmfGraph graph) throws AssertionError {
        Collection graphObjects = graph.geteObjects();
        for (EObject eObject : group) {
            if (!graphObjects.contains(eObject)) {
                throw new AssertionError((Object)"expected: No element from group deleted, but at least one element was deleted.");
            }
        }
    }
}

