/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.actions;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.henshin.editor.actions.EcoreSelectionDialogUtil;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.presentation.HenshinEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ImportPackageAction
implements IObjectActionDelegate {
    public static final String FROM_WORKSPACE_ACTION_ID = "importFromWorkspace";
    public static final String FROM_REGISTRY_ACTION_ID = "importFromRegistry";
    protected IWorkbenchPart workbenchPart;
    protected TransformationSystem transformationSystem;

    public void run(IAction action) {
        Shell shell = this.workbenchPart.getSite().getShell();
        ResourceSet resourceSet = this.transformationSystem.eResource().getResourceSet();
        EPackage newPackage = FROM_WORKSPACE_ACTION_ID.equals(action.getId()) ? EcoreSelectionDialogUtil.selectEcoreFilePackage(shell, resourceSet) : EcoreSelectionDialogUtil.selectRegisteredPackage(shell, resourceSet);
        if (newPackage != null && newPackage.getNsURI() != null) {
            this.runImportCommand(newPackage);
        }
    }

    protected void runImportCommand(final EPackage epackage) {
        AbstractCommand command = new AbstractCommand("Import Package"){

            public boolean canUndo() {
                return false;
            }

            public boolean prepare() {
                return true;
            }

            public void execute() {
                this.redo();
            }

            public void redo() {
                ImportPackageAction.this.doImport(epackage);
            }
        };
        HenshinEditor editor = (HenshinEditor)this.workbenchPart;
        CommandStack stack = editor.getEditingDomain().getCommandStack();
        stack.execute((Command)command);
    }

    protected void doImport(EPackage epackage) {
        String nsURI = epackage.getNsURI();
        int i = 0;
        while (i < this.transformationSystem.getImports().size()) {
            EPackage current = (EPackage)this.transformationSystem.getImports().get(i);
            if (nsURI.equals(current.getNsURI()) && epackage != current) {
                this.transformationSystem.getImports().set(i, (Object)epackage);
                return;
            }
            ++i;
        }
        this.transformationSystem.getImports().add((Object)epackage);
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.workbenchPart = part instanceof HenshinEditor ? part : null;
        action.setEnabled(this.workbenchPart != null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        this.transformationSystem = null;
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof TransformationSystem) {
            this.transformationSystem = (TransformationSystem)first;
        }
        action.setEnabled(this.transformationSystem != null);
    }
}

