/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.ocl.LazyExtentMap;
import org.eclipse.ocl.ecore.EcoreEvaluationEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QVTExtentMap
extends HashMap<EClass, Set<EObject>> {
    private static final long serialVersionUID = -7110659347649872111L;
    private EcoreEvaluationEnvironment fEvalEnv;

    QVTExtentMap(EcoreEvaluationEnvironment evalEnv) {
        if (evalEnv == null) {
            throw new IllegalArgumentException();
        }
        this.fEvalEnv = evalEnv;
    }

    @Override
    public Set<EObject> get(Object key) {
        if (key instanceof EClass) {
            return this.collectInstances((EClass)key);
        }
        return Collections.emptySet();
    }

    private List<ModelParameterExtent> getExtents() {
        InternalEvaluationEnv internEvalEnv = (InternalEvaluationEnv)this.fEvalEnv.getAdapter(InternalEvaluationEnv.class);
        TransformationInstance thisObj = internEvalEnv.getCurrentTransformation();
        if (thisObj instanceof TransformationInstance) {
            TransformationInstance thisTransf = thisObj;
            LinkedList<ModelParameterExtent> extents = new LinkedList<ModelParameterExtent>();
            for (ModelParameter modelParam : thisTransf.getTransformation().getModelParameter()) {
                ModelInstance model = thisTransf.getModel(modelParam);
                extents.add(model.getExtent());
            }
            extents.add(internEvalEnv.getUnboundExtent());
            return extents;
        }
        return null;
    }

    private Set<EObject> collectInstances(EClass context) {
        List<ModelParameterExtent> extents = this.getExtents();
        if (extents == null) {
            Object selfObj = this.fEvalEnv.getValueOf("self");
            if (selfObj instanceof EObject) {
                return new LazyExtentMap<EClass, EObject>((EObject)selfObj){

                    protected boolean isInstance(EClass cls, EObject element) {
                        return QVTExtentMap.this.fEvalEnv.isKindOf((Object)element, (EClassifier)cls);
                    }
                }.get((Object)context);
            }
            return Collections.emptySet();
        }
        HashSet<EObject> result = new HashSet<EObject>();
        for (ModelParameterExtent nextExtent : extents) {
            for (Object nextObj : nextExtent.getAllObjects()) {
                if (!(nextObj instanceof EObject) || !this.fEvalEnv.isKindOf(nextObj, (EClassifier)context)) continue;
                result.add((EObject)nextObj);
            }
        }
        return result;
    }
}

