/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.utilities;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.umlx.RelDiagram;
import org.eclipse.qvtd.umlx.RelDomainNode;
import org.eclipse.qvtd.umlx.RelInvocationEdge;
import org.eclipse.qvtd.umlx.RelInvocationNode;
import org.eclipse.qvtd.umlx.RelPatternEdge;
import org.eclipse.qvtd.umlx.RelPatternNode;
import org.eclipse.qvtd.umlx.TxDiagram;
import org.eclipse.qvtd.umlx.TxKeyNode;
import org.eclipse.qvtd.umlx.TxPackageNode;
import org.eclipse.qvtd.umlx.TxParameterNode;
import org.eclipse.qvtd.umlx.TxPartNode;
import org.eclipse.qvtd.umlx.TxQueryNode;
import org.eclipse.qvtd.umlx.TxTypedModelNode;
import org.eclipse.qvtd.umlx.UMLXElement;
import org.eclipse.qvtd.umlx.UMLXModel;
import org.eclipse.qvtd.umlx.UMLXNamedElement;
import org.eclipse.qvtd.umlx.UMLXTypedElement;

public class UMLXUtil {
    public static void assertClassNode(@NonNull RelPatternNode relPatternNode) {
        assert (!relPatternNode.isExpression().booleanValue());
        assert (relPatternNode.getName() != null);
        assert (relPatternNode.getReferredEClassifier() != null);
    }

    public static void assertExpressionNode(@NonNull RelPatternNode relPatternNode) {
        assert (relPatternNode.isExpression().booleanValue());
        assert (!relPatternNode.getInitExpressionLines().isEmpty());
        assert (relPatternNode.getName() == null);
        assert (relPatternNode.getOutgoing().isEmpty());
        assert (relPatternNode.getReferredEClassifier() == null);
        assert (!relPatternNode.isIsRoot());
    }

    public static @NonNull Iterable<@NonNull String> getComments(@NonNull UMLXElement umlxElement) {
        return ClassUtil.nullFree(umlxElement.getComments());
    }

    public static @NonNull Iterable<@NonNull TxTypedModelNode> getDependsOns(@NonNull TxTypedModelNode txTypedModelNode) {
        return ClassUtil.nullFree(txTypedModelNode.getDependsOns());
    }

    public static @NonNull Iterable<@NonNull String> getImportAliases(@NonNull TxPackageNode txPackageNode) {
        return ClassUtil.nullFree(txPackageNode.getImportAliases());
    }

    public static @NonNull Iterable<@NonNull RelPatternEdge> getIncoming(@NonNull RelPatternNode relNode) {
        return ClassUtil.nullFree(relNode.getIncoming());
    }

    public static @NonNull List<@NonNull String> getInitExpressionLines(@NonNull RelPatternNode relPatternNode) {
        return ClassUtil.nullFree(relPatternNode.getInitExpressionLines());
    }

    public static @NonNull RelPatternNode getInvokingRelPatternNode(@NonNull RelInvocationEdge relInvocationEdge) {
        return (RelPatternNode)ClassUtil.nonNullState((Object)relInvocationEdge.getInvokingRelPatternNode());
    }

    public static @NonNull String getName(@NonNull UMLXNamedElement umlxElement) {
        return (String)ClassUtil.nonNullState((Object)umlxElement.getName());
    }

    public static @NonNull Iterable<@NonNull RelPatternEdge> getOutgoing(@NonNull RelPatternNode relNode) {
        return ClassUtil.nullFree(relNode.getOutgoing());
    }

    public static @NonNull Iterable<@NonNull RelDiagram> getOwnedRelDiagrams(@NonNull TxDiagram txDiagram) {
        return ClassUtil.nullFree(txDiagram.getOwnedRelDiagrams());
    }

    public static @NonNull Iterable<@NonNull RelDomainNode> getOwnedRelDomainNodes(@NonNull RelDiagram relDiagram) {
        return ClassUtil.nullFree(relDiagram.getOwnedRelDomainNodes());
    }

    public static @NonNull Iterable<@NonNull RelInvocationEdge> getOwnedRelInvocationEdges(@NonNull RelInvocationNode relInvocationNode) {
        return ClassUtil.nullFree(relInvocationNode.getOwnedRelInvocationEdges());
    }

    public static @NonNull Iterable<@NonNull RelInvocationNode> getOwnedRelInvocationNodes(@NonNull RelDiagram relDiagram) {
        return ClassUtil.nullFree(relDiagram.getOwnedRelInvocationNodes());
    }

    public static @NonNull Iterable<@NonNull RelPatternEdge> getOwnedRelPatternEdges(@NonNull RelDomainNode relDomainNode) {
        return ClassUtil.nullFree(relDomainNode.getOwnedRelPatternEdges());
    }

    public static @NonNull Iterable<@NonNull RelPatternNode> getOwnedRelPatternNodes(@NonNull RelDomainNode relDomainNode) {
        return ClassUtil.nullFree(relDomainNode.getOwnedRelPatternNodes());
    }

    public static @NonNull Iterable<@NonNull TxDiagram> getOwnedTxDiagrams(@NonNull UMLXModel umlxModel) {
        return ClassUtil.nullFree(umlxModel.getOwnedTxDiagrams());
    }

    public static @NonNull Iterable<@NonNull TxKeyNode> getOwnedTxKeyNodes(@NonNull TxDiagram txDiagram) {
        return ClassUtil.nullFree(txDiagram.getOwnedTxKeyNodes());
    }

    public static @NonNull Iterable<@NonNull TxPackageNode> getOwnedTxPackageNodes(@NonNull TxDiagram txDiagram) {
        return ClassUtil.nullFree(txDiagram.getOwnedTxPackageNodes());
    }

    public static @NonNull Iterable<@NonNull TxParameterNode> getOwnedTxParameterNodes(@NonNull TxQueryNode txTypedModelNode) {
        return ClassUtil.nullFree(txTypedModelNode.getOwnedTxParameterNodes());
    }

    public static @NonNull Iterable<@NonNull TxPartNode> getOwnedTxPartNodes(@NonNull TxKeyNode txKeyNode) {
        return ClassUtil.nullFree(txKeyNode.getOwnedTxPartNodes());
    }

    public static @NonNull Iterable<@NonNull TxQueryNode> getOwnedTxQueryNodes(@NonNull TxDiagram txDiagram) {
        return ClassUtil.nullFree(txDiagram.getOwnedTxQueryNodes());
    }

    public static @NonNull Iterable<@NonNull TxTypedModelNode> getOwnedTxTypedModelNodes(@NonNull TxDiagram txDiagram) {
        return ClassUtil.nullFree(txDiagram.getOwnedTxTypedModelNodes());
    }

    public static @NonNull RelDiagram getOwningRelDiagram(@NonNull RelInvocationNode relInvocationNode) {
        return (RelDiagram)ClassUtil.nonNullState((Object)relInvocationNode.getOwningRelDiagram());
    }

    public static @NonNull RelDomainNode getOwningRelDomainNode(@NonNull RelPatternNode relPatternNode) {
        return (RelDomainNode)ClassUtil.nonNullState((Object)relPatternNode.getOwningRelDomainNode());
    }

    public static @NonNull EClass getReferredEClass(@NonNull TxKeyNode txKeyNode) {
        return (EClass)ClassUtil.nonNullState((Object)txKeyNode.getReferredEClass());
    }

    public static @NonNull EClassifier getReferredEClassifier(@NonNull UMLXTypedElement umlxTypedElement) {
        return (EClassifier)ClassUtil.nonNullState((Object)umlxTypedElement.getReferredEClassifier());
    }

    public static @NonNull EPackage getReferredEPackage(@NonNull TxPackageNode txPackageNode) {
        return (EPackage)ClassUtil.nonNullState((Object)txPackageNode.getReferredEPackage());
    }

    public static @NonNull EStructuralFeature getReferredEStructuralFeature(@NonNull RelPatternEdge relPatternEdge) {
        return (EStructuralFeature)ClassUtil.nonNullState((Object)relPatternEdge.getReferredEStructuralFeature());
    }

    public static @NonNull EStructuralFeature getReferredEStructuralFeature(@NonNull TxPartNode txPartNode) {
        return (EStructuralFeature)ClassUtil.nonNullState((Object)txPartNode.getReferredEStructuralFeature());
    }

    public static @NonNull RelDiagram getReferredRelDiagram(@NonNull RelInvocationNode relInvocationNode) {
        return (RelDiagram)ClassUtil.nonNullState((Object)relInvocationNode.getReferredRelDiagram());
    }

    public static @NonNull RelPatternNode getReferredRelPatternNode(@NonNull RelInvocationEdge relInvocationEdge) {
        return (RelPatternNode)ClassUtil.nonNullState((Object)relInvocationEdge.getReferredRelPatternNode());
    }

    public static @NonNull TxTypedModelNode getReferredTxTypedModelNode(@NonNull RelDomainNode relDomainNode) {
        return (TxTypedModelNode)ClassUtil.nonNullState((Object)relDomainNode.getReferredTxTypedModelNode());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull Iterable<@NonNull RelPatternNode> getRootPatternClassNodes(@NonNull RelDomainNode relDomainNode) {
        @NonNull EList nullFree = ClassUtil.nullFree(relDomainNode.getOwnedRelPatternNodes());
        return Iterables.filter((Iterable)nullFree, (Predicate)IsRootPredicate.INSTANCE);
    }

    public static @NonNull RelPatternNode getSource(@NonNull RelPatternEdge relPatternEdge) {
        return (RelPatternNode)ClassUtil.nonNullState((Object)relPatternEdge.getSource());
    }

    public static @NonNull RelPatternNode getTarget(@NonNull RelPatternEdge relPatternEdge) {
        return (RelPatternNode)ClassUtil.nonNullState((Object)relPatternEdge.getTarget());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull List<@NonNull RelInvocationEdge> getSortedInvocationEdges(@NonNull RelInvocationNode relInvocationNode) {
        final HashMap<@NonNull RelPatternNode, @NonNull Integer> node2index = new HashMap<RelPatternNode, Integer>();
        @NonNull ArrayList sortedRelDomainNodes = Lists.newArrayList(UMLXUtil.getOwnedRelDomainNodes(UMLXUtil.getReferredRelDiagram(relInvocationNode)));
        Collections.sort(sortedRelDomainNodes, RelDomainNodeComparator.INSTANCE);
        for (RelDomainNode relDomainNode : sortedRelDomainNodes) {
            @NonNull ArrayList sortedRootNodes = Lists.newArrayList(UMLXUtil.getRootPatternClassNodes(relDomainNode));
            Collections.sort(sortedRootNodes, RelPatternNodeComparator.INSTANCE);
            for (RelPatternNode relPatternClassNode : sortedRootNodes) {
                node2index.put(relPatternClassNode, node2index.size());
            }
        }
        @NonNull ArrayList sortedEdges = Lists.newArrayList(UMLXUtil.getOwnedRelInvocationEdges(relInvocationNode));
        Collections.sort(sortedEdges, new Comparator<RelInvocationEdge>(){

            @Override
            public int compare(@NonNull RelInvocationEdge o1, @NonNull RelInvocationEdge o2) {
                Integer i1 = (Integer)node2index.get(o1.getReferredRelPatternNode());
                Integer i2 = (Integer)node2index.get(o2.getReferredRelPatternNode());
                if (!($assertionsDisabled || i1 != null && i2 != null)) {
                    throw new AssertionError();
                }
                return i1 - i2;
            }
        });
        return sortedEdges;
    }

    public static @NonNull Iterable<@NonNull TxPackageNode> getUsedTxPackageNodes(@NonNull TxTypedModelNode txTypedModelNode) {
        return ClassUtil.nullFree(txTypedModelNode.getUsedTxPackageNodes());
    }

    public static class Internal
    extends UMLXUtil {
        public static @NonNull List<@NonNull RelPatternEdge> getIncomingList(@NonNull RelPatternNode relNode) {
            return ClassUtil.nullFree(relNode.getIncoming());
        }

        public static @NonNull List<@NonNull RelPatternNode> getOwnedRelPatternNodesList(@NonNull RelDomainNode relDomainNode) {
            return ClassUtil.nullFree(relDomainNode.getOwnedRelPatternNodes());
        }
    }

    public static final class IsRootPredicate
    implements Predicate<RelPatternNode> {
        public static final @NonNull IsRootPredicate INSTANCE = new IsRootPredicate();

        public boolean apply(@NonNull RelPatternNode input) {
            return input.isIsRoot();
        }
    }

    public static final class RelDomainNodeComparator
    implements Comparator<RelDomainNode> {
        public static final @NonNull RelDomainNodeComparator INSTANCE = new RelDomainNodeComparator();

        @Override
        public int compare(@NonNull RelDomainNode o1, @NonNull RelDomainNode o2) {
            TxTypedModelNode t1 = o1.getReferredTxTypedModelNode();
            TxTypedModelNode t2 = o2.getReferredTxTypedModelNode();
            String n1 = t1 != null ? t1.getName() : "";
            String n2 = t2 != null ? t2.getName() : "";
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }

    public static final class RelPatternNodeComparator
    implements Comparator<RelPatternNode> {
        public static final @NonNull RelPatternNodeComparator INSTANCE = new RelPatternNodeComparator();

        @Override
        public int compare(@NonNull RelPatternNode o1, @NonNull RelPatternNode o2) {
            UMLXUtil.assertClassNode(o1);
            UMLXUtil.assertClassNode(o2);
            String n1 = o1.getName();
            String n2 = o2.getName();
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

